/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.wayproperty.specifier;

import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.openstreetmap.wayproperty.specifier.Condition;
import org.opentripplanner.openstreetmap.wayproperty.specifier.OsmSpecifier;

public class BestMatchSpecifier
implements OsmSpecifier {
    public static final int EXACT_MATCH_SCORE = 100;
    public static final int WILDCARD_MATCH_SCORE = 1;
    public static final int NO_MATCH_SCORE = 0;
    private final Condition[] conditions;

    public BestMatchSpecifier(String spec) {
        this.conditions = OsmSpecifier.parseConditions(spec, ";");
    }

    @Override
    public OsmSpecifier.Scores matchScores(OSMWithTags way) {
        int backwardScore = 0;
        int forwardScore = 0;
        int backwardMatches = 0;
        int forwardMatches = 0;
        for (Condition test : this.conditions) {
            Condition.MatchResult forwardMatch = test.matchForward(way);
            Condition.MatchResult backwardMatch = test.matchBackward(way);
            int backwardTagScore = BestMatchSpecifier.toTagScore(backwardMatch);
            backwardScore += backwardTagScore;
            if (backwardTagScore > 0) {
                ++backwardMatches;
            }
            int forwardTagScore = BestMatchSpecifier.toTagScore(forwardMatch);
            forwardScore += forwardTagScore;
            if (forwardTagScore <= 0) continue;
            ++forwardMatches;
        }
        int allMatchBackwardBonus = backwardMatches == this.conditions.length ? 10 : 0;
        int allMatchForwardBonus = forwardMatches == this.conditions.length ? 10 : 0;
        return new OsmSpecifier.Scores(forwardScore += allMatchForwardBonus, backwardScore += allMatchBackwardBonus);
    }

    @Override
    public int matchScore(OSMWithTags way) {
        int score = 0;
        int matches = 0;
        for (Condition test : this.conditions) {
            Condition.MatchResult matchValue = test.match(way);
            int tagScore = BestMatchSpecifier.toTagScore(matchValue);
            score += tagScore;
            if (tagScore <= 0) continue;
            ++matches;
        }
        return score += matches == this.conditions.length ? 10 : 0;
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("conditions", this.conditions).toString();
    }

    private static int toTagScore(Condition.MatchResult res) {
        return switch (res) {
            default -> throw new IncompatibleClassChangeError();
            case Condition.MatchResult.EXACT -> 100;
            case Condition.MatchResult.WILDCARD -> 1;
            case Condition.MatchResult.NONE -> 0;
        };
    }
}

