/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.wayproperty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.framework.functional.FunctionUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.openstreetmap.wayproperty.CreativeNamer;
import org.opentripplanner.openstreetmap.wayproperty.CreativeNamerPicker;
import org.opentripplanner.openstreetmap.wayproperty.MixinProperties;
import org.opentripplanner.openstreetmap.wayproperty.MixinPropertiesBuilder;
import org.opentripplanner.openstreetmap.wayproperty.NotePicker;
import org.opentripplanner.openstreetmap.wayproperty.NoteProperties;
import org.opentripplanner.openstreetmap.wayproperty.SafetyFeatures;
import org.opentripplanner.openstreetmap.wayproperty.SlopeOverridePicker;
import org.opentripplanner.openstreetmap.wayproperty.SpeedPicker;
import org.opentripplanner.openstreetmap.wayproperty.WayProperties;
import org.opentripplanner.openstreetmap.wayproperty.WayPropertiesBuilder;
import org.opentripplanner.openstreetmap.wayproperty.WayPropertyPicker;
import org.opentripplanner.openstreetmap.wayproperty.specifier.BestMatchSpecifier;
import org.opentripplanner.openstreetmap.wayproperty.specifier.OsmSpecifier;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.note.StreetNoteAndMatcher;
import org.opentripplanner.street.model.note.StreetNoteMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WayPropertySet {
    private static final Logger LOG = LoggerFactory.getLogger(WayPropertySet.class);
    private final FunctionUtils.TriFunction<StreetTraversalPermission, Float, OSMWithTags, Double> DEFAULT_SAFETY_RESOLVER = (permission, speedLimit, osmWay) -> 1.0;
    private final List<WayPropertyPicker> wayProperties;
    private final List<CreativeNamerPicker> creativeNamers;
    private final List<SlopeOverridePicker> slopeOverrides;
    private final List<SpeedPicker> speedPickers;
    private final List<NotePicker> notes;
    private final Pattern maxSpeedPattern;
    public Float defaultSpeed;
    private FunctionUtils.TriFunction<StreetTraversalPermission, Float, OSMWithTags, Double> defaultWalkSafetyForPermission;
    private FunctionUtils.TriFunction<StreetTraversalPermission, Float, OSMWithTags, Double> defaultBicycleSafetyForPermission;
    private final WayProperties defaultProperties;
    private final List<MixinProperties> mixins = new ArrayList<MixinProperties>();

    public List<MixinProperties> getMixins() {
        return this.mixins;
    }

    public WayPropertySet() {
        this.defaultSpeed = Float.valueOf(11.2f);
        this.defaultProperties = WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).build();
        this.wayProperties = new ArrayList<WayPropertyPicker>();
        this.creativeNamers = new ArrayList<CreativeNamerPicker>();
        this.slopeOverrides = new ArrayList<SlopeOverridePicker>();
        this.speedPickers = new ArrayList<SpeedPicker>();
        this.notes = new ArrayList<NotePicker>();
        this.maxSpeedPattern = Pattern.compile("^([0-9][.0-9]*)\\s*(kmh|km/h|kmph|kph|mph|knots)?$");
        this.defaultWalkSafetyForPermission = this.DEFAULT_SAFETY_RESOLVER;
        this.defaultBicycleSafetyForPermission = this.DEFAULT_SAFETY_RESOLVER;
    }

    public WayProperties getDataForWay(OSMWithTags way) {
        WayProperties backwardResult = this.defaultProperties;
        WayProperties forwardResult = this.defaultProperties;
        int bestBackwardScore = 0;
        int bestForwardScore = 0;
        ArrayList<MixinProperties> backwardMixins = new ArrayList<MixinProperties>();
        ArrayList<MixinProperties> forwardMixins = new ArrayList<MixinProperties>();
        for (WayPropertyPicker picker : this.wayProperties) {
            OsmSpecifier specifier = picker.specifier();
            WayProperties wayProperties = picker.properties();
            OsmSpecifier.Scores score = specifier.matchScores(way);
            if (score.backward() > bestBackwardScore) {
                backwardResult = wayProperties;
                bestBackwardScore = score.backward();
            }
            if (score.forward() <= bestForwardScore) continue;
            forwardResult = wayProperties;
            bestForwardScore = score.forward();
        }
        for (MixinProperties mixin : this.mixins) {
            OsmSpecifier.Scores score = mixin.specifier().matchScores(way);
            if (score.backward() > 0) {
                backwardMixins.add(mixin);
            }
            if (score.forward() <= 0) continue;
            forwardMixins.add(mixin);
        }
        float forwardSpeed = this.getCarSpeedForWay(way, false);
        float backSpeed = this.getCarSpeedForWay(way, true);
        StreetTraversalPermission permission = forwardResult.getPermission();
        StreetTraversalPermission backwardPermission = backwardResult.getPermission();
        WayProperties result = forwardResult.mutate().bicycleSafety(forwardResult.getBicycleSafetyFeatures() != null ? forwardResult.getBicycleSafetyFeatures().forward() : this.defaultBicycleSafetyForPermission.apply(permission, Float.valueOf(forwardSpeed), way).doubleValue(), backwardResult.getBicycleSafetyFeatures() != null ? backwardResult.getBicycleSafetyFeatures().back() : this.defaultBicycleSafetyForPermission.apply(backwardPermission, Float.valueOf(backSpeed), way).doubleValue()).walkSafety(forwardResult.getWalkSafetyFeatures() != null ? forwardResult.getWalkSafetyFeatures().forward() : this.defaultWalkSafetyForPermission.apply(permission, Float.valueOf(forwardSpeed), way).doubleValue(), backwardResult.getWalkSafetyFeatures() != null ? backwardResult.getWalkSafetyFeatures().back() : this.defaultWalkSafetyForPermission.apply(backwardPermission, Float.valueOf(backSpeed), way).doubleValue()).build();
        if (backwardMixins.size() > 0) {
            result = this.applyMixins(result, backwardMixins, true);
        }
        if (forwardMixins.size() > 0) {
            result = this.applyMixins(result, forwardMixins, false);
        }
        if (!(bestBackwardScore != 0 && bestForwardScore != 0 || backwardMixins.size() != 0 && forwardMixins.size() != 0)) {
            String all_tags = this.dumpTags(way);
            LOG.debug("Used default permissions: {}", (Object)all_tags);
        }
        return result;
    }

    public I18NString getCreativeNameForWay(OSMWithTags way) {
        CreativeNamer bestNamer = null;
        int bestScore = 0;
        for (CreativeNamerPicker picker : this.creativeNamers) {
            OsmSpecifier specifier = picker.specifier;
            CreativeNamer namer = picker.namer;
            int score = specifier.matchScore(way);
            if (score <= bestScore) continue;
            bestNamer = namer;
            bestScore = score;
        }
        if (bestNamer == null) {
            return null;
        }
        return bestNamer.generateCreativeName(way);
    }

    public float getCarSpeedForWay(OSMWithTags way, boolean backward) {
        Float speed = null;
        if (way.hasTag("maxspeed:motorcar")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:motorcar"));
        }
        if (speed == null && !backward && way.hasTag("maxspeed:forward")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:forward"));
        }
        if (speed == null && backward && way.hasTag("maxspeed:backward")) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed:backward"));
        }
        if (speed == null && way.hasTag("maxspeed:lanes")) {
            for (String lane : way.getTag("maxspeed:lanes").split("\\|")) {
                Float currentSpeed = this.getMetersSecondFromSpeed(lane);
                if (currentSpeed == null || speed != null && !(currentSpeed.floatValue() > speed.floatValue())) continue;
                speed = currentSpeed;
            }
        }
        if (way.hasTag("maxspeed") && speed == null) {
            speed = this.getMetersSecondFromSpeed(way.getTag("maxspeed"));
        }
        if (speed != null && (double)speed.floatValue() < 1.0E-4) {
            LOG.warn("Zero or negative automobile speed detected at {} based on OSM maxspeed tags; ignoring these tags", (Object)this);
        }
        if (speed != null && (double)speed.floatValue() > 1.0E-4) {
            return speed.floatValue();
        }
        int bestScore = 0;
        Float bestSpeed = null;
        for (SpeedPicker picker : this.speedPickers) {
            OsmSpecifier specifier = picker.specifier;
            int score = specifier.matchScore(way);
            if (score <= bestScore) continue;
            bestScore = score;
            bestSpeed = Float.valueOf(picker.speed);
        }
        if (bestSpeed != null) {
            return bestSpeed.floatValue();
        }
        return this.defaultSpeed.floatValue();
    }

    public Set<StreetNoteAndMatcher> getNoteForWay(OSMWithTags way) {
        HashSet<StreetNoteAndMatcher> out = new HashSet<StreetNoteAndMatcher>();
        for (NotePicker picker : this.notes) {
            OsmSpecifier specifier = picker.specifier;
            NoteProperties noteProperties = picker.noteProperties;
            if (specifier.matchScore(way) <= 0) continue;
            out.add(noteProperties.generateNote(way));
        }
        if (out.size() == 0) {
            return null;
        }
        return out;
    }

    public boolean getSlopeOverride(OSMWithTags way) {
        boolean result = false;
        int bestScore = 0;
        for (SlopeOverridePicker picker : this.slopeOverrides) {
            OsmSpecifier specifier = picker.getSpecifier();
            int score = specifier.matchScore(way);
            if (score <= bestScore) continue;
            result = picker.getOverride();
            bestScore = score;
        }
        return result;
    }

    public void addMixin(MixinProperties mixin) {
        this.mixins.add(mixin);
    }

    public void addProperties(OsmSpecifier spec, WayProperties properties) {
        this.wayProperties.add(new WayPropertyPicker(spec, properties));
    }

    public void addCreativeNamer(OsmSpecifier spec, CreativeNamer namer) {
        this.creativeNamers.add(new CreativeNamerPicker(spec, namer));
    }

    public void addNote(OsmSpecifier osmSpecifier, NoteProperties properties) {
        this.notes.add(new NotePicker(osmSpecifier, properties));
    }

    public void setSlopeOverride(OsmSpecifier spec, boolean override) {
        this.slopeOverrides.add(new SlopeOverridePicker(spec, override));
    }

    public int hashCode() {
        return this.defaultProperties.hashCode() + this.wayProperties.hashCode() + this.creativeNamers.hashCode() + this.slopeOverrides.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof WayPropertySet) {
            WayPropertySet other = (WayPropertySet)o;
            return this.defaultProperties.equals(other.defaultProperties) && this.wayProperties.equals(other.wayProperties) && this.creativeNamers.equals(other.creativeNamers) && this.slopeOverrides.equals(other.slopeOverrides) && this.notes.equals(other.notes);
        }
        return false;
    }

    public void addSpeedPicker(SpeedPicker picker) {
        this.speedPickers.add(picker);
    }

    public Float getMetersSecondFromSpeed(String speed) {
        float metersSecond;
        float originalUnits;
        Matcher m = this.maxSpeedPattern.matcher(speed.trim());
        if (!m.matches()) {
            return null;
        }
        try {
            originalUnits = (float)Double.parseDouble(m.group(1));
        }
        catch (NumberFormatException e) {
            LOG.warn("Could not parse max speed {}", (Object)m.group(1));
            return null;
        }
        String units = m.group(2);
        if (units == null || units.equals("")) {
            units = "kmh";
        }
        switch (units = units.intern()) {
            case "kmh": 
            case "km/h": 
            case "kmph": 
            case "kph": {
                metersSecond = 0.277778f * originalUnits;
                break;
            }
            case "mph": {
                metersSecond = 0.446944f * originalUnits;
                break;
            }
            case "knots": {
                metersSecond = 0.514444f * originalUnits;
                break;
            }
            default: {
                return null;
            }
        }
        return Float.valueOf(metersSecond);
    }

    public void createNames(String spec, String patternKey) {
        CreativeNamer namer = new CreativeNamer(patternKey);
        this.addCreativeNamer(new BestMatchSpecifier(spec), namer);
    }

    public void createNotes(String spec, String patternKey, StreetNoteMatcher matcher) {
        NoteProperties properties = new NoteProperties(patternKey, matcher);
        this.addNote(new BestMatchSpecifier(spec), properties);
    }

    public void setDefaultWalkSafetyForPermission(FunctionUtils.TriFunction<StreetTraversalPermission, Float, OSMWithTags, Double> defaultWalkSafetyForPermission) {
        if (!this.defaultWalkSafetyForPermission.equals(this.DEFAULT_SAFETY_RESOLVER)) {
            throw new IllegalStateException("A custom default walk safety resolver was already set");
        }
        this.defaultWalkSafetyForPermission = defaultWalkSafetyForPermission;
    }

    public void setDefaultBicycleSafetyForPermission(FunctionUtils.TriFunction<StreetTraversalPermission, Float, OSMWithTags, Double> defaultBicycleSafetyForPermission) {
        if (!this.defaultBicycleSafetyForPermission.equals(this.DEFAULT_SAFETY_RESOLVER)) {
            throw new IllegalStateException("A custom default cycling safety resolver was already set");
        }
        this.defaultBicycleSafetyForPermission = defaultBicycleSafetyForPermission;
    }

    public void setMixinProperties(OsmSpecifier spec, MixinPropertiesBuilder builder) {
        this.addMixin(builder.build(spec));
    }

    public void setMixinProperties(String spec, MixinPropertiesBuilder builder) {
        this.setMixinProperties(new BestMatchSpecifier(spec), builder);
    }

    public void setProperties(String s, WayProperties props) {
        this.setProperties((OsmSpecifier)new BestMatchSpecifier(s), props);
    }

    public void setProperties(String spec, WayPropertiesBuilder properties) {
        this.setProperties((OsmSpecifier)new BestMatchSpecifier(spec), properties);
    }

    public void setProperties(OsmSpecifier spec, WayProperties properties) {
        this.addProperties(spec, properties);
    }

    public void setProperties(OsmSpecifier spec, WayPropertiesBuilder properties) {
        this.addProperties(spec, properties.build());
    }

    public void setCarSpeed(String spec, float speed) {
        SpeedPicker picker = new SpeedPicker();
        picker.specifier = new BestMatchSpecifier(spec);
        picker.speed = speed;
        this.addSpeedPicker(picker);
    }

    public void setCarSpeed(OsmSpecifier spec, float speed) {
        SpeedPicker picker = new SpeedPicker();
        picker.specifier = spec;
        picker.speed = speed;
        this.addSpeedPicker(picker);
    }

    public List<WayPropertyPicker> getWayProperties() {
        return Collections.unmodifiableList(this.wayProperties);
    }

    private String dumpTags(OSMWithTags way) {
        String all_tags = null;
        Map<String, String> tags = way.getTags();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String tag = key + "=" + value;
            if (all_tags == null) {
                all_tags = tag;
                continue;
            }
            all_tags = all_tags + "; " + tag;
        }
        return all_tags;
    }

    private WayProperties applyMixins(WayProperties result, List<MixinProperties> mixins, boolean backward) {
        SafetyFeatures bicycleSafetyFeatures = result.getBicycleSafetyFeatures();
        double forwardBicycle = bicycleSafetyFeatures.forward();
        double backBicycle = bicycleSafetyFeatures.back();
        SafetyFeatures walkSafetyFeatures = result.getWalkSafetyFeatures();
        double forwardWalk = walkSafetyFeatures.forward();
        double backWalk = walkSafetyFeatures.back();
        for (MixinProperties mixin : mixins) {
            if (backward) {
                if (mixin.bicycleSafety() != null) {
                    backBicycle *= mixin.bicycleSafety().back();
                }
                if (mixin.walkSafety() == null) continue;
                backWalk *= mixin.walkSafety().back();
                continue;
            }
            if (mixin.bicycleSafety() != null) {
                forwardBicycle *= mixin.bicycleSafety().forward();
            }
            if (mixin.walkSafety() == null) continue;
            forwardWalk *= mixin.walkSafety().forward();
        }
        return result.mutate().bicycleSafety(forwardBicycle, backBicycle).walkSafety(forwardWalk, backWalk).build();
    }
}

