/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.wayproperty;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.LocalizedString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.resources.ResourceBundleSingleton;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

class LocalizedStringMapper {
    private static final LocalizedStringMapper INSTANCE = new LocalizedStringMapper();
    private static final Pattern PATTERN_MATCHER = Pattern.compile("\\{(.*?)}");
    private final ListMultimap<String, String> keyTagNames = ArrayListMultimap.create();

    LocalizedStringMapper() {
    }

    static LocalizedStringMapper getInstance() {
        return INSTANCE;
    }

    LocalizedString map(String key, OSMWithTags way) {
        ArrayList<NonLocalizedString> lparams = new ArrayList<NonLocalizedString>(4);
        List<String> tagNames = this.getTagNames(key);
        for (String it : tagNames) {
            String param = way.getTag(it);
            lparams.add(new NonLocalizedString(Objects.requireNonNullElse(param, "")));
        }
        return new LocalizedString(key, lparams.toArray(new I18NString[0]));
    }

    private List<String> getTagNames(String key) {
        if (this.keyTagNames.containsKey((Object)key)) {
            return this.keyTagNames.get((Object)key);
        }
        ArrayList<String> tagNames = new ArrayList<String>(4);
        String englishTrans = ResourceBundleSingleton.INSTANCE.localize(key, Locale.ENGLISH);
        Matcher matcher = PATTERN_MATCHER.matcher(englishTrans);
        while (matcher.find()) {
            String tagName = matcher.group(1);
            this.keyTagNames.put((Object)key, (Object)tagName);
            tagNames.add(tagName);
        }
        return tagNames;
    }
}

