/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.tagmapping;

import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.openstreetmap.wayproperty.WayPropertySet;

public interface OsmTagMapper {
    public void populateProperties(WayPropertySet var1);

    default public boolean doesTagValueDisallowThroughTraffic(String tagValue) {
        return "no".equals(tagValue) || "destination".equals(tagValue) || "private".equals(tagValue) || "customers".equals(tagValue) || "delivery".equals(tagValue);
    }

    default public boolean isGeneralNoThroughTraffic(OSMWithTags way) {
        String access = way.getTag("access");
        return this.doesTagValueDisallowThroughTraffic(access);
    }

    default public boolean isVehicleThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String vehicle = way.getTag("vehicle");
        if (vehicle != null) {
            return this.doesTagValueDisallowThroughTraffic(vehicle);
        }
        return this.isGeneralNoThroughTraffic(way);
    }

    default public boolean isMotorVehicleThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String motorVehicle = way.getTag("motor_vehicle");
        if (motorVehicle != null) {
            return this.doesTagValueDisallowThroughTraffic(motorVehicle);
        }
        return this.isVehicleThroughTrafficExplicitlyDisallowed(way);
    }

    default public boolean isBicycleNoThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String bicycle = way.getTag("bicycle");
        if (bicycle != null) {
            return this.doesTagValueDisallowThroughTraffic(bicycle);
        }
        return this.isVehicleThroughTrafficExplicitlyDisallowed(way);
    }

    default public boolean isWalkNoThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String foot = way.getTag("foot");
        if (foot != null) {
            return this.doesTagValueDisallowThroughTraffic(foot);
        }
        return this.isGeneralNoThroughTraffic(way);
    }
}

