/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap.tagmapping;

import org.opentripplanner.framework.functional.FunctionUtils;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.openstreetmap.tagmapping.DefaultMapper;
import org.opentripplanner.openstreetmap.tagmapping.OsmTagMapper;
import org.opentripplanner.openstreetmap.wayproperty.WayPropertiesBuilder;
import org.opentripplanner.openstreetmap.wayproperty.WayPropertySet;
import org.opentripplanner.street.model.StreetTraversalPermission;

class FinlandMapper
implements OsmTagMapper {
    FinlandMapper() {
    }

    @Override
    public void populateProperties(WayPropertySet props) {
        FunctionUtils.TriFunction<StreetTraversalPermission, Float, OSMWithTags, Double> defaultWalkSafetyForPermission = (permission, speedLimit, way) -> switch (permission) {
            default -> throw new IncompatibleClassChangeError();
            case StreetTraversalPermission.ALL, StreetTraversalPermission.PEDESTRIAN_AND_CAR -> {
                if (speedLimit.floatValue() <= 9.75f) {
                    yield 1.45;
                }
                if (speedLimit.floatValue() <= 16.65f) {
                    yield 1.6;
                }
                yield 1.8;
            }
            case StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE -> 1.15;
            case StreetTraversalPermission.PEDESTRIAN -> 1.1;
            case StreetTraversalPermission.BICYCLE_AND_CAR, StreetTraversalPermission.BICYCLE, StreetTraversalPermission.CAR, StreetTraversalPermission.NONE -> 1.8;
        };
        props.setDefaultWalkSafetyForPermission(defaultWalkSafetyForPermission);
        props.setProperties("highway=living_street", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.9));
        props.setProperties("highway=unclassified", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL));
        props.setProperties("highway=road", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL));
        props.setProperties("highway=byway", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setProperties("highway=track", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.3));
        props.setProperties("highway=service", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1));
        props.setProperties("highway=residential", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=residential_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(0.98));
        props.setProperties("highway=tertiary", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL));
        props.setProperties("highway=tertiary_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL));
        props.setProperties("highway=secondary", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setProperties("highway=secondary_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.5));
        props.setProperties("highway=primary", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06));
        props.setProperties("highway=primary_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06));
        props.setProperties("highway=trunk_link", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(2.06));
        props.setProperties("highway=trunk", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(7.47));
        props.setProperties("highway=trunk;tunnel=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR).bicycleSafety(7.47));
        props.setProperties("motorroad=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.CAR).bicycleSafety(7.47));
        props.setProperties("highway=*;informal=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties("highway=service;access=private", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties("highway=trail", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties("highway=footway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN));
        props.setProperties("footway=sidewalk;highway=footway", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN));
        props.setProperties("highway=cycleway;segregated=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.1).bicycleSafety(0.6));
        props.setProperties("highway=footway;bridge=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.0));
        props.setProperties("highway=footway;tunnel=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.0));
        props.setProperties("highway=cycleway;bridge=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.0).bicycleSafety(0.6));
        props.setProperties("highway=cycleway;tunnel=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.0).bicycleSafety(0.6));
        props.setProperties("highway=footway;footway=crossing;crossing=traffic_signals", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.1));
        props.setProperties("highway=footway;footway=crossing", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.2));
        props.setProperties("highway=cycleway;cycleway=crossing;segregated=yes;crossing=traffic_signals", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.1).bicycleSafety(0.8));
        props.setProperties("highway=cycleway;footway=crossing;segregated=yes;crossing=traffic_signals", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.1).bicycleSafety(0.8));
        props.setProperties("highway=cycleway;cycleway=crossing;segregated=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.2).bicycleSafety(1.2));
        props.setProperties("highway=cycleway;footway=crossing;segregated=yes", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN).walkSafety(1.2).bicycleSafety(1.2));
        props.setProperties("highway=cycleway;cycleway=crossing;crossing=traffic_signals", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.15).bicycleSafety(0.8));
        props.setProperties("highway=cycleway;footway=crossing;crossing=traffic_signals", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.15).bicycleSafety(0.8));
        props.setProperties("highway=cycleway;cycleway=crossing", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.25).bicycleSafety(1.2));
        props.setProperties("highway=cycleway;footway=crossing", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).walkSafety(1.25).bicycleSafety(1.2));
        props.setProperties("highway=cycleway;bicycle=designated", WayPropertiesBuilder.withModes(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE).bicycleSafety(0.6));
        props.setProperties("highway=service;tunnel=yes;access=destination", WayPropertiesBuilder.withModes(StreetTraversalPermission.NONE));
        props.setProperties("highway=service;access=destination", WayPropertiesBuilder.withModes(StreetTraversalPermission.ALL).bicycleSafety(1.1));
        props.setCarSpeed("highway=motorway", 27.77f);
        props.setCarSpeed("highway=motorway_link", 15.0f);
        props.setCarSpeed("highway=trunk", 22.22f);
        props.setCarSpeed("highway=trunk_link", 15.0f);
        props.setCarSpeed("highway=primary", 22.22f);
        props.setCarSpeed("highway=primary_link", 15.0f);
        props.setCarSpeed("highway=secondary", 19.45f);
        props.setCarSpeed("highway=secondary_link", 15.0f);
        props.setCarSpeed("highway=tertiary", 16.65f);
        props.setCarSpeed("highway=tertiary_link", 11.2f);
        props.setCarSpeed("highway=unclassified", 11.2f);
        props.setCarSpeed("highway=road", 11.2f);
        props.setCarSpeed("highway=residential", 9.75f);
        props.setCarSpeed("highway=service", 5.55f);
        props.setCarSpeed("highway=living_street", 5.55f);
        props.setCarSpeed("highway=track", 4.5f);
        new DefaultMapper().populateProperties(props);
    }

    @Override
    public boolean isBicycleNoThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String bicycle = way.getTag("bicycle");
        return this.isVehicleThroughTrafficExplicitlyDisallowed(way) || this.doesTagValueDisallowThroughTraffic(bicycle);
    }

    @Override
    public boolean isWalkNoThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String foot = way.getTag("foot");
        return this.isGeneralNoThroughTraffic(way) || this.doesTagValueDisallowThroughTraffic(foot);
    }
}

