/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.openstreetmap;

import ch.poole.openinghoursparser.DateRange;
import ch.poole.openinghoursparser.DateWithOffset;
import ch.poole.openinghoursparser.OpeningHoursParseException;
import ch.poole.openinghoursparser.OpeningHoursParser;
import ch.poole.openinghoursparser.Rule;
import ch.poole.openinghoursparser.RuleModifier;
import ch.poole.openinghoursparser.TimeSpan;
import ch.poole.openinghoursparser.WeekDay;
import ch.poole.openinghoursparser.WeekDayRange;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.model.calendar.openinghours.OHCalendar;
import org.opentripplanner.model.calendar.openinghours.OHCalendarBuilder;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMOpeningHoursParser {
    private static final Logger LOG = LoggerFactory.getLogger(OSMOpeningHoursParser.class);
    private final OpeningHoursCalendarService openingHoursCalendarService;
    private final Supplier<ZoneId> zoneIdSupplier;
    private final DataImportIssueStore issueStore;
    private static final Set<RuleModifier.Modifier> CLOSED_MODIFIERS = Set.of(RuleModifier.Modifier.CLOSED, RuleModifier.Modifier.OFF);
    private static final Set<RuleModifier.Modifier> OPEN_MODIFIERS = Set.of(RuleModifier.Modifier.OPEN, RuleModifier.Modifier.UNKNOWN);
    private static final Map<WeekDay, DayOfWeek> dayOfWeekMap = Map.ofEntries(Map.entry(WeekDay.MO, DayOfWeek.MONDAY), Map.entry(WeekDay.TU, DayOfWeek.TUESDAY), Map.entry(WeekDay.WE, DayOfWeek.WEDNESDAY), Map.entry(WeekDay.TH, DayOfWeek.THURSDAY), Map.entry(WeekDay.FR, DayOfWeek.FRIDAY), Map.entry(WeekDay.SA, DayOfWeek.SATURDAY), Map.entry(WeekDay.SU, DayOfWeek.SUNDAY));
    private static final Map<ch.poole.openinghoursparser.Month, Month> monthMap = Map.ofEntries(Map.entry(ch.poole.openinghoursparser.Month.JAN, Month.JANUARY), Map.entry(ch.poole.openinghoursparser.Month.FEB, Month.FEBRUARY), Map.entry(ch.poole.openinghoursparser.Month.MAR, Month.MARCH), Map.entry(ch.poole.openinghoursparser.Month.APR, Month.APRIL), Map.entry(ch.poole.openinghoursparser.Month.MAY, Month.MAY), Map.entry(ch.poole.openinghoursparser.Month.JUN, Month.JUNE), Map.entry(ch.poole.openinghoursparser.Month.JUL, Month.JULY), Map.entry(ch.poole.openinghoursparser.Month.AUG, Month.AUGUST), Map.entry(ch.poole.openinghoursparser.Month.SEP, Month.SEPTEMBER), Map.entry(ch.poole.openinghoursparser.Month.OCT, Month.OCTOBER), Map.entry(ch.poole.openinghoursparser.Month.NOV, Month.NOVEMBER), Map.entry(ch.poole.openinghoursparser.Month.DEC, Month.DECEMBER));

    public OSMOpeningHoursParser(OpeningHoursCalendarService openingHoursCalendarService, DataImportIssueStore issueStore) {
        this(openingHoursCalendarService, () -> null, issueStore);
    }

    public OSMOpeningHoursParser(OpeningHoursCalendarService openingHoursCalendarService, Supplier<ZoneId> zoneIdSupplier, DataImportIssueStore issueStore) {
        this.openingHoursCalendarService = openingHoursCalendarService;
        this.zoneIdSupplier = zoneIdSupplier;
        this.issueStore = issueStore;
    }

    public OSMOpeningHoursParser(OpeningHoursCalendarService openingHoursCalendarService, ZoneId zoneId) {
        this.openingHoursCalendarService = openingHoursCalendarService;
        this.zoneIdSupplier = () -> zoneId;
        this.issueStore = null;
    }

    public OHCalendar parseOpeningHours(String openingHoursTag, String id, String link) throws OpeningHoursParseException {
        ZoneId zoneId = this.zoneIdSupplier.get();
        if (zoneId == null) {
            return null;
        }
        return this.parseOpeningHours(openingHoursTag, id, link, zoneId);
    }

    public OHCalendar parseOpeningHours(String openingHoursTag, String id, String link, ZoneId zoneId) throws OpeningHoursParseException {
        OHCalendarBuilder calendarBuilder = this.openingHoursCalendarService.newBuilder(zoneId);
        OpeningHoursParser parser = new OpeningHoursParser((InputStream)new ByteArrayInputStream(openingHoursTag.getBytes()));
        List rules = parser.rules(false);
        List<Rule> rulesWithoutFallback = rules.stream().filter(rule -> !rule.isFallBack()).collect(Collectors.toList());
        ArrayList openingHoursBuilders = new ArrayList();
        rulesWithoutFallback.forEach(rule -> {
            ArrayList<OHCalendarBuilder.OpeningHoursBuilder> openingHoursBuildersForRule = new ArrayList<OHCalendarBuilder.OpeningHoursBuilder>();
            if (this.is247Rule((Rule)rule)) {
                openingHoursBuildersForRule.add(this.createOHCalendarBuilderForOpen247(calendarBuilder));
            } else if (rule.getYears() != null) {
                this.logUnhandled((Rule)rule, openingHoursTag, id, link);
            } else if (rule.getDates() != null) {
                openingHoursBuildersForRule.addAll(this.createOHCalendarBuildersForDates(calendarBuilder, (Rule)rule));
            } else if (rule.getWeeks() != null) {
                this.logUnhandled((Rule)rule, openingHoursTag, id, link);
            } else if (rule.getDays() != null) {
                openingHoursBuildersForRule.addAll(this.createOHCalendarBuildersForDayRanges(calendarBuilder, (Rule)rule));
            }
            if (this.isClosedRule((Rule)rule) && this.hasTimes((Rule)rule)) {
                openingHoursBuildersForRule.forEach(openingHoursBuilder -> openingHoursBuilders.addAll(this.splitPreviousBuilders((OHCalendarBuilder.OpeningHoursBuilder)openingHoursBuilder, openingHoursBuilders)));
            } else if (!rule.isAdditive()) {
                openingHoursBuildersForRule.stream().filter(openingHoursBuilder -> !openingHoursBuilder.isAfterMidnight()).forEach(openingHoursBuilder -> this.editPreviousBuilders((OHCalendarBuilder.OpeningHoursBuilder)openingHoursBuilder, openingHoursBuilders));
            }
            if (this.isOpenRule((Rule)rule)) {
                openingHoursBuilders.addAll(openingHoursBuildersForRule.stream().filter(OHCalendarBuilder.OpeningHoursBuilder::isEverOn).collect(Collectors.toList()));
            }
        });
        openingHoursBuilders.forEach(openingHoursBuilder -> openingHoursBuilder.add());
        return calendarBuilder.build();
    }

    private List<OHCalendarBuilder.OpeningHoursBuilder> createOHCalendarBuildersForOpen24DayRanges(OHCalendarBuilder calendarBuilder, List<WeekDayRange> dayRanges) {
        return dayRanges.stream().map(dayRange -> this.setWeekDayRangeRangeForOpeningHoursBuilder(calendarBuilder.openingHours(dayRange.toString(), LocalTime.MIN, LocalTime.MAX), (WeekDayRange)dayRange)).collect(Collectors.toList());
    }

    private List<OHCalendarBuilder.OpeningHoursBuilder> createOHCalendarBuildersForDates(OHCalendarBuilder calendarBuilder, Rule rule) {
        return rule.getDates().stream().flatMap(dateRange -> {
            if (rule.getDays() != null) {
                return rule.getDays().stream().flatMap(weekDayRange -> {
                    String description = String.format("%s %s", dateRange.toString(), weekDayRange.toString());
                    if (rule.getTimes() != null) {
                        return rule.getTimes().stream().flatMap(timeSpan -> this.createOHCalendarBuildersForTimeSpan(calendarBuilder, description, (TimeSpan)timeSpan).stream().map(openingHoursBuilder -> this.setDateRangeForOpeningHoursBuilder((OHCalendarBuilder.OpeningHoursBuilder)openingHoursBuilder, (DateRange)dateRange, (WeekDayRange)weekDayRange)));
                    }
                    return Stream.of(new OHCalendarBuilder.OpeningHoursBuilder[0]);
                });
            }
            return Stream.of(new OHCalendarBuilder.OpeningHoursBuilder[0]);
        }).collect(Collectors.toList());
    }

    private OHCalendarBuilder.OpeningHoursBuilder setDateRangeForOpeningHoursBuilder(OHCalendarBuilder.OpeningHoursBuilder openingHoursBuilder, DateRange dateRange, WeekDayRange weekDayRange) {
        DateWithOffset startDate = dateRange.getStartDate();
        DateWithOffset endDate = dateRange.getEndDate();
        if (weekDayRange != null) {
            if (weekDayRange.getStartDay() == null || startDate == null || startDate.getMonth() == null) {
                return openingHoursBuilder;
            }
            DayOfWeek startDayOfWeek = dayOfWeekMap.getOrDefault(weekDayRange.getStartDay(), null);
            DayOfWeek endDayOfWeek = weekDayRange.getEndDay() != null ? (DayOfWeek)dayOfWeekMap.getOrDefault(weekDayRange.getEndDay(), null) : null;
            Month startMonth = monthMap.getOrDefault(startDate.getMonth(), null);
            Month endMonth = endDate != null && endDate.getMonth() != null ? (Month)monthMap.getOrDefault(endDate.getMonth(), null) : null;
            openingHoursBuilder.on(startMonth, endMonth, startDayOfWeek, endDayOfWeek);
        }
        return openingHoursBuilder;
    }

    private List<OHCalendarBuilder.OpeningHoursBuilder> createOHCalendarBuildersForDayRanges(OHCalendarBuilder calendarBuilder, Rule rule) {
        if (rule.getTimes() == null) {
            return this.createOHCalendarBuildersForOpen24DayRanges(calendarBuilder, rule.getDays());
        }
        return rule.getDays().stream().flatMap(dayRange -> {
            String description = dayRange.toString();
            return rule.getTimes().stream().flatMap(timeSpan -> this.createOHCalendarBuildersForTimeSpan(calendarBuilder, description, (TimeSpan)timeSpan).stream().map(openingHoursBuilder -> this.setWeekDayRangeRangeForOpeningHoursBuilder((OHCalendarBuilder.OpeningHoursBuilder)openingHoursBuilder, (WeekDayRange)dayRange)));
        }).collect(Collectors.toList());
    }

    private OHCalendarBuilder.OpeningHoursBuilder setWeekDayRangeRangeForOpeningHoursBuilder(OHCalendarBuilder.OpeningHoursBuilder openingHoursBuilder, WeekDayRange weekDayRange) {
        if (weekDayRange.getStartDay() == null) {
            return openingHoursBuilder;
        }
        DayOfWeek startDayOfWeek = dayOfWeekMap.getOrDefault(weekDayRange.getStartDay(), null);
        if (weekDayRange.getEndDay() != null) {
            return openingHoursBuilder.on(startDayOfWeek, dayOfWeekMap.getOrDefault(weekDayRange.getEndDay(), null));
        }
        return openingHoursBuilder.on(startDayOfWeek);
    }

    private List<OHCalendarBuilder.OpeningHoursBuilder> createOHCalendarBuildersForTimeSpan(OHCalendarBuilder calendarBuilder, String description, TimeSpan timeSpan) {
        if (timeSpan.getStart() < 0) {
            return List.of();
        }
        if (timeSpan.getEnd() > 1440) {
            return List.of(calendarBuilder.openingHours(description, this.getStartTime(timeSpan.getStart()), LocalTime.MAX), calendarBuilder.openingHours(description + " after midnight", LocalTime.MIN, this.getEndTime(timeSpan.getEnd() - 1440), true));
        }
        return List.of(calendarBuilder.openingHours(description, this.getStartTime(timeSpan.getStart()), this.getEndTime(timeSpan.getEnd()), false));
    }

    private OHCalendarBuilder.OpeningHoursBuilder createOHCalendarBuilderForOpen247(OHCalendarBuilder calendarBuilder) {
        OHCalendarBuilder.OpeningHoursBuilder openingHoursBuilder = calendarBuilder.openingHours("Every day", LocalTime.MIN, LocalTime.MAX);
        return openingHoursBuilder.everyDay();
    }

    private void editPreviousBuilders(OHCalendarBuilder.OpeningHoursBuilder newOpeningHoursBuilder, List<OHCalendarBuilder.OpeningHoursBuilder> previousOpeningHoursBuilders) {
        previousOpeningHoursBuilders.stream().forEach(openingHoursBuilder -> openingHoursBuilder.offWithTimeShift(newOpeningHoursBuilder));
    }

    private List<OHCalendarBuilder.OpeningHoursBuilder> splitPreviousBuilders(OHCalendarBuilder.OpeningHoursBuilder closedOpeningHoursBuilder, List<OHCalendarBuilder.OpeningHoursBuilder> previousOpeningHoursBuilders) {
        return previousOpeningHoursBuilders.stream().flatMap(openingHoursBuilder -> {
            OHCalendarBuilder.OpeningHoursBuilderAndNewBuilders openingHoursBuilderAndNewBuilders = openingHoursBuilder.createBuildersForRelativeComplement(closedOpeningHoursBuilder);
            return openingHoursBuilderAndNewBuilders.newBuilders().stream();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private LocalTime getStartTime(int startTimeMinutes) {
        return LocalTime.ofSecondOfDay(startTimeMinutes * 60);
    }

    private LocalTime getEndTime(int endTimeMinutes) {
        if (endTimeMinutes < 0) {
            return LocalTime.MAX;
        }
        return LocalTime.ofSecondOfDay(Math.min(endTimeMinutes * 60, 86399));
    }

    private boolean isOpenRule(Rule rule) {
        RuleModifier modifier = rule.getModifier();
        return modifier == null || modifier.getModifier() != null && OPEN_MODIFIERS.contains(modifier.getModifier());
    }

    private boolean isClosedRule(Rule rule) {
        RuleModifier modifier = rule.getModifier();
        return modifier != null && modifier.getModifier() != null && CLOSED_MODIFIERS.contains(modifier.getModifier());
    }

    private boolean hasTimes(Rule rule) {
        return rule.getTimes() != null && rule.getTimes().stream().anyMatch(timeSpan -> timeSpan.getStart() > 0);
    }

    private boolean is247Rule(Rule rule) {
        return (this.isOpenRule(rule) || this.isClosedRule(rule)) && (rule.isTwentyfourseven() || rule.getHolidays() == null && rule.getYears() == null && rule.getDays() == null && rule.getTimes() == null && rule.getDates() == null && rule.getWeeks() == null && rule.getComment() == null);
    }

    private void logUnhandled(Rule rule, String ohTag, String id, String link) {
        String message;
        String string = message = link != null ? String.format("Rule %s is unhandled in the opening hours definition %s for %s (%s)", rule, ohTag, id, link) : String.format("Rule %s is unhandled in the opening hours definition %s for %s", rule, ohTag, id);
        if (this.issueStore != null) {
            this.issueStore.add("UnhandledOHRule", message);
        } else {
            LOG.info(message);
        }
    }
}

