/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.support;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.rutebanken.netex.model.EntityInVersionStructure;
import org.rutebanken.netex.model.ValidBetween;

public class NetexVersionHelper {
    private NetexVersionHelper() {
    }

    public static int versionOf(EntityInVersionStructure e) {
        return Integer.parseInt(e.getVersion());
    }

    public static int latestVersionIn(Collection<? extends EntityInVersionStructure> list) {
        return list.stream().mapToInt(NetexVersionHelper::versionOf).max().orElse(-1);
    }

    public static <T extends EntityInVersionStructure> T latestVersionedElementIn(Collection<T> list) {
        return (T)((EntityInVersionStructure)list.stream().max(NetexVersionHelper.comparingVersion()).orElse(null));
    }

    public static <T extends EntityInVersionStructure> Comparator<T> comparingVersion() {
        return Comparator.comparingInt(NetexVersionHelper::versionOf);
    }

    public static LocalDateTime firstValidDateTime(List<ValidBetween> periods, LocalDateTime timestamp) {
        if (periods.isEmpty()) {
            return timestamp;
        }
        LocalDateTime firstTime = null;
        for (ValidBetween p : periods) {
            if (p.getToDate() != null && p.getToDate().isBefore(timestamp)) continue;
            if (p.getFromDate() == null || p.getFromDate().isBefore(timestamp)) {
                return timestamp;
            }
            if (firstTime != null && !p.getFromDate().isBefore(firstTime)) continue;
            firstTime = p.getFromDate();
        }
        return firstTime;
    }
}

