/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.xml.bind.JAXBElement;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.netex.mapping.ServiceLinkMapper;
import org.opentripplanner.netex.mapping.StopTimesMapper;
import org.opentripplanner.netex.mapping.StopTimesMapperResult;
import org.opentripplanner.netex.mapping.TripMapper;
import org.opentripplanner.netex.mapping.TripPatternMapperResult;
import org.opentripplanner.netex.mapping.TripServiceAlterationMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.network.TripPatternBuilder;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripAlteration;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.DatedServiceJourneyRefStructure;
import org.rutebanken.netex.model.DestinationDisplay;
import org.rutebanken.netex.model.FlexibleLine;
import org.rutebanken.netex.model.JourneyPatternRefStructure;
import org.rutebanken.netex.model.JourneyPattern_VersionStructure;
import org.rutebanken.netex.model.JourneyRefStructure;
import org.rutebanken.netex.model.LineRefStructure;
import org.rutebanken.netex.model.OperatingDay;
import org.rutebanken.netex.model.RouteView;
import org.rutebanken.netex.model.ServiceJourney;
import org.rutebanken.netex.model.ServiceLink;
import org.rutebanken.netex.model.TimetabledPassingTime;
import org.rutebanken.netex.model.VersionOfObjectRefStructure;

class TripPatternMapper {
    public static final String HEADSIGN_EMPTY = "";
    private final DataImportIssueStore issueStore;
    private final FeedScopedIdFactory idFactory;
    private final EntityById<Route> otpRouteById;
    private final ReadOnlyHierarchicalMap<String, org.rutebanken.netex.model.Route> routeById;
    private final Multimap<String, ServiceJourney> serviceJourniesByPatternId = ArrayListMultimap.create();
    private final ReadOnlyHierarchicalMapById<OperatingDay> operatingDayById;
    private final Multimap<String, DatedServiceJourney> datedServiceJourneysBySJId;
    private final ReadOnlyHierarchicalMapById<DatedServiceJourney> datedServiceJourneyById;
    private final ReadOnlyHierarchicalMap<String, ServiceJourney> serviceJourneyById;
    private final TripMapper tripMapper;
    private final StopTimesMapper stopTimesMapper;
    private final ServiceLinkMapper serviceLinkMapper;
    private final Deduplicator deduplicator;
    private TripPatternMapperResult result;

    TripPatternMapper(DataImportIssueStore issueStore, FeedScopedIdFactory idFactory, EntityById<Operator> operatorById, EntityById<RegularStop> stopById, EntityById<AreaStop> areaStopById, EntityById<GroupStop> groupStopById, EntityById<Route> otpRouteById, ReadOnlyHierarchicalMap<String, org.rutebanken.netex.model.Route> routeById, ReadOnlyHierarchicalMap<String, JourneyPattern_VersionStructure> journeyPatternById, ReadOnlyHierarchicalMap<String, String> quayIdByStopPointRef, ReadOnlyHierarchicalMap<String, String> flexibleStopPlaceIdByStopPointRef, ReadOnlyHierarchicalMap<String, DestinationDisplay> destinationDisplayById, ReadOnlyHierarchicalMap<String, ServiceJourney> serviceJourneyById, ReadOnlyHierarchicalMapById<ServiceLink> serviceLinkById, ReadOnlyHierarchicalMapById<FlexibleLine> flexibleLineById, ReadOnlyHierarchicalMapById<OperatingDay> operatingDayById, ReadOnlyHierarchicalMapById<DatedServiceJourney> datedServiceJourneyById, Multimap<String, DatedServiceJourney> datedServiceJourneysBySJId, Map<String, FeedScopedId> serviceIds, Deduplicator deduplicator, double maxStopToShapeSnapDistance) {
        this.issueStore = issueStore;
        this.idFactory = idFactory;
        this.routeById = routeById;
        this.otpRouteById = otpRouteById;
        this.operatingDayById = operatingDayById;
        this.datedServiceJourneysBySJId = datedServiceJourneysBySJId;
        this.tripMapper = new TripMapper(idFactory, issueStore, operatorById, otpRouteById, routeById, journeyPatternById, serviceIds);
        this.stopTimesMapper = new StopTimesMapper(issueStore, idFactory, stopById, areaStopById, groupStopById, destinationDisplayById, quayIdByStopPointRef, flexibleStopPlaceIdByStopPointRef, flexibleLineById, routeById);
        this.serviceLinkMapper = new ServiceLinkMapper(idFactory, serviceLinkById, quayIdByStopPointRef, stopById, issueStore, maxStopToShapeSnapDistance);
        this.deduplicator = deduplicator;
        this.datedServiceJourneyById = datedServiceJourneyById;
        this.serviceJourneyById = serviceJourneyById;
        for (ServiceJourney sj : serviceJourneyById.localValues()) {
            this.serviceJourniesByPatternId.put((Object)((JourneyPatternRefStructure)sj.getJourneyPatternRef().getValue()).getRef(), (Object)sj);
        }
    }

    TripPatternMapperResult mapTripPattern(JourneyPattern_VersionStructure journeyPattern) {
        boolean hasMultipleSubmodes;
        boolean hasMultipleModes;
        this.result = new TripPatternMapperResult();
        Collection serviceJourneys = this.serviceJourniesByPatternId.get((Object)journeyPattern.getId());
        if (serviceJourneys.isEmpty()) {
            this.issueStore.add("ServiceJourneyPatternIsEmpty", "ServiceJourneyPattern %s does not contain any serviceJourneys.", journeyPattern.getId());
            return this.result;
        }
        ArrayList<Trip> trips = new ArrayList<Trip>();
        for (ServiceJourney serviceJourney : serviceJourneys) {
            Trip trip = this.mapTrip(journeyPattern, serviceJourney);
            if (trip == null) continue;
            this.mapDatedServiceJourney(journeyPattern, serviceJourney, trip);
            StopTimesMapperResult stopTimes = this.stopTimesMapper.mapToStopTimes(journeyPattern, trip, serviceJourney.getPassingTimes().getTimetabledPassingTime(), serviceJourney);
            if (stopTimes == null) continue;
            this.result.scheduledStopPointsIndex.putAll((Object)serviceJourney.getId(), stopTimes.scheduledStopPointIds);
            this.result.tripStopTimes.put(trip, stopTimes.stopTimes);
            this.result.stopTimeByNetexId.putAll(stopTimes.stopTimeByNetexId);
            trips.add(trip);
        }
        if (trips.isEmpty()) {
            return this.result;
        }
        StopPattern stopPattern = this.deduplicator.deduplicateObject(StopPattern.class, new StopPattern((Collection<StopTime>)this.result.tripStopTimes.get(trips.get(0))));
        HashSet<TransitMode> tripPatternModes = new HashSet<TransitMode>();
        HashSet<SubMode> tripPatternSubmodes = new HashSet<SubMode>();
        for (Trip trip : trips) {
            tripPatternModes.add(trip.getMode());
            tripPatternSubmodes.add(trip.getNetexSubMode());
        }
        boolean bl = hasMultipleModes = tripPatternModes.size() > 1;
        if (hasMultipleModes) {
            this.issueStore.add("ServiceJourneyPatternHasMultipleModes", "ServiceJourneyPattern %s contains multiple modes: %s", journeyPattern.getId(), tripPatternModes.stream().map(Enum::name).collect(Collectors.joining(", ")));
        }
        boolean bl2 = hasMultipleSubmodes = tripPatternSubmodes.size() > 1;
        if (hasMultipleSubmodes) {
            this.issueStore.add("ServiceJourneyPatternHasMultipleSubModes", "ServiceJourneyPattern %s contains multiple sub-modes: %s", journeyPattern.getId(), tripPatternSubmodes.stream().map(SubMode::name).collect(Collectors.joining(", ")));
        }
        TripPatternBuilder tripPatternBuilder = TripPattern.of(this.idFactory.createId(journeyPattern.getId())).withRoute(this.lookupRoute(journeyPattern)).withStopPattern(stopPattern).withMode(((Trip)trips.get(0)).getMode()).withNetexSubmode(((Trip)trips.get(0)).getNetexSubMode()).withContainsMultipleModes(hasMultipleModes || hasMultipleSubmodes).withName(journeyPattern.getName() == null ? HEADSIGN_EMPTY : journeyPattern.getName().getValue()).withHopGeometries(this.serviceLinkMapper.getGeometriesByJourneyPattern(journeyPattern, stopPattern));
        TripPattern tripPattern = (TripPattern)tripPatternBuilder.build();
        this.createTripTimes(trips, tripPattern);
        this.result.tripPatterns.put((Object)stopPattern, (Object)tripPattern);
        return this.result;
    }

    private void mapDatedServiceJourney(JourneyPattern_VersionStructure journeyPattern, ServiceJourney serviceJourney, Trip trip) {
        if (this.datedServiceJourneysBySJId.containsKey((Object)serviceJourney.getId())) {
            for (DatedServiceJourney datedServiceJourney : this.datedServiceJourneysBySJId.get((Object)serviceJourney.getId())) {
                this.result.tripOnServiceDates.add(this.mapDatedServiceJourney(journeyPattern, trip, datedServiceJourney));
            }
        }
    }

    private TripOnServiceDate mapDatedServiceJourney(JourneyPattern_VersionStructure journeyPattern, Trip trip, DatedServiceJourney datedServiceJourney) {
        OperatingDay opDay = (OperatingDay)this.operatingDayById.lookup(datedServiceJourney.getOperatingDayRef().getRef());
        if (opDay == null) {
            return null;
        }
        LocalDate serviceDate = opDay.getCalendarDate().toLocalDate();
        FeedScopedId id = this.idFactory.createId(datedServiceJourney.getId());
        TripAlteration alteration = TripServiceAlterationMapper.mapAlteration(datedServiceJourney.getServiceAlteration());
        List<TripOnServiceDate> replacementFor = datedServiceJourney.getJourneyRef().stream().map(JAXBElement::getValue).filter(DatedServiceJourneyRefStructure.class::isInstance).map(DatedServiceJourneyRefStructure.class::cast).map(VersionOfObjectRefStructure::getRef).map(this.datedServiceJourneyById::lookup).filter(Objects::nonNull).map(replacement -> {
            if (datedServiceJourney.equals(replacement)) {
                this.issueStore.add("InvalidDatedServiceJourneyRef", "DatedServiceJourney %s has reference to itself, skipping", datedServiceJourney.getId());
                return null;
            }
            String serviceJourneyRef = ((JourneyRefStructure)((JAXBElement)replacement.getJourneyRef().get(0)).getValue()).getRef();
            ServiceJourney serviceJourney = this.serviceJourneyById.lookup(serviceJourneyRef);
            if (serviceJourney == null) {
                this.issueStore.add("InvalidDatedServiceJourneyRef", "DatedServiceJourney %s has reference to %s, which is not found, skipping", datedServiceJourney.getId(), serviceJourneyRef);
                return null;
            }
            return this.mapDatedServiceJourney(journeyPattern, this.mapTrip(journeyPattern, serviceJourney), (DatedServiceJourney)replacement);
        }).filter(Objects::nonNull).toList();
        return (TripOnServiceDate)TripOnServiceDate.of(id).withTrip(trip).withServiceDate(serviceDate).withTripAlteration(alteration).withReplacementFor(replacementFor).build();
    }

    private Route lookupRoute(JourneyPattern_VersionStructure journeyPattern) {
        String lineId = null;
        if (journeyPattern.getRouteRef() != null) {
            org.rutebanken.netex.model.Route route = this.routeById.lookup(journeyPattern.getRouteRef().getRef());
            lineId = ((LineRefStructure)route.getLineRef().getValue()).getRef();
        } else {
            RouteView routeView = journeyPattern.getRouteView();
            lineId = ((LineRefStructure)routeView.getLineRef().getValue()).getRef();
        }
        return this.otpRouteById.get(this.idFactory.createId(lineId));
    }

    private void createTripTimes(List<Trip> trips, TripPattern tripPattern) {
        for (Trip trip : trips) {
            if (this.result.tripStopTimes.get(trip).size() == 0) {
                this.issueStore.add("TripWithoutTripTimes", "Trip %s does not contain any trip times.", trip.getId());
                continue;
            }
            TripTimes tripTimes = new TripTimes(trip, (Collection<StopTime>)this.result.tripStopTimes.get(trip), this.deduplicator);
            tripPattern.add(tripTimes);
        }
    }

    private Trip mapTrip(JourneyPattern_VersionStructure journeyPattern, ServiceJourney serviceJourney) {
        return this.tripMapper.mapServiceJourney(serviceJourney, () -> this.findTripHeadsign(journeyPattern, serviceJourney));
    }

    private String findTripHeadsign(JourneyPattern_VersionStructure journeyPattern, ServiceJourney serviceJourney) {
        List times = serviceJourney.getPassingTimes().getTimetabledPassingTime();
        if (times == null || times.isEmpty()) {
            return HEADSIGN_EMPTY;
        }
        String headsign = this.stopTimesMapper.findTripHeadsign(journeyPattern, (TimetabledPassingTime)times.get(0));
        return headsign == null ? HEADSIGN_EMPTY : headsign;
    }
}

