/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import org.opentripplanner.netex.mapping.support.NetexMainAndSubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.rutebanken.netex.model.StopPlace;
import org.rutebanken.netex.model.VehicleModeEnumeration;

class StopPlaceTypeMapper {
    StopPlaceTypeMapper() {
    }

    public NetexMainAndSubMode map(StopPlace stopPlace) {
        NetexMainAndSubMode submode = this.getSubmodeAsString(stopPlace);
        if (submode != null) {
            return submode;
        }
        TransitMode mode = this.mapVehicleMode(stopPlace);
        return new NetexMainAndSubMode(mode, null);
    }

    private TransitMode mapVehicleMode(StopPlace stopPlace) {
        if (stopPlace.getTransportMode() == null) {
            return null;
        }
        return switch (stopPlace.getTransportMode()) {
            default -> throw new IncompatibleClassChangeError();
            case VehicleModeEnumeration.AIR -> TransitMode.AIRPLANE;
            case VehicleModeEnumeration.BUS -> TransitMode.BUS;
            case VehicleModeEnumeration.TROLLEY_BUS -> TransitMode.TROLLEYBUS;
            case VehicleModeEnumeration.CABLEWAY -> TransitMode.CABLE_CAR;
            case VehicleModeEnumeration.COACH -> TransitMode.COACH;
            case VehicleModeEnumeration.FUNICULAR -> TransitMode.FUNICULAR;
            case VehicleModeEnumeration.METRO -> TransitMode.SUBWAY;
            case VehicleModeEnumeration.RAIL -> TransitMode.RAIL;
            case VehicleModeEnumeration.TRAM -> TransitMode.TRAM;
            case VehicleModeEnumeration.WATER, VehicleModeEnumeration.FERRY -> TransitMode.FERRY;
            case VehicleModeEnumeration.LIFT, VehicleModeEnumeration.OTHER, VehicleModeEnumeration.SNOW_AND_ICE -> null;
        };
    }

    private NetexMainAndSubMode getSubmodeAsString(StopPlace stopPlace) {
        if (stopPlace.getAirSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.AIRPLANE, stopPlace.getAirSubmode().value());
        }
        if (stopPlace.getBusSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.BUS, stopPlace.getBusSubmode().value());
        }
        if (stopPlace.getTelecabinSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.GONDOLA, stopPlace.getTelecabinSubmode().value());
        }
        if (stopPlace.getCoachSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.COACH, stopPlace.getCoachSubmode().value());
        }
        if (stopPlace.getFunicularSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.FUNICULAR, stopPlace.getFunicularSubmode().value());
        }
        if (stopPlace.getMetroSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.SUBWAY, stopPlace.getMetroSubmode().value());
        }
        if (stopPlace.getRailSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.RAIL, stopPlace.getRailSubmode().value());
        }
        if (stopPlace.getTramSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.TRAM, stopPlace.getTramSubmode().value());
        }
        if (stopPlace.getWaterSubmode() != null) {
            return new NetexMainAndSubMode(TransitMode.FERRY, stopPlace.getWaterSubmode().value());
        }
        return null;
    }
}

