/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.netex.mapping.WgsCoordinateMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.GroupOfStations;
import org.opentripplanner.transit.model.site.GroupOfStationsBuilder;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.rutebanken.netex.model.GroupOfStopPlaces;
import org.rutebanken.netex.model.StopPlaceRefStructure;
import org.rutebanken.netex.model.StopPlaceRefs_RelStructure;

class GroupOfStationsMapper {
    private final DataImportIssueStore issueStore;
    private final FeedScopedIdFactory idFactory;
    private final EntityById<MultiModalStation> multiModalStations;
    private final EntityById<Station> stations;

    GroupOfStationsMapper(DataImportIssueStore issueStore, FeedScopedIdFactory idFactory, EntityById<MultiModalStation> multiModalStations, EntityById<Station> stations) {
        this.issueStore = issueStore;
        this.idFactory = idFactory;
        this.multiModalStations = multiModalStations;
        this.stations = stations;
    }

    GroupOfStations map(GroupOfStopPlaces groupOfStopPlaces) {
        I18NString name;
        if (groupOfStopPlaces.getName() != null) {
            name = NonLocalizedString.ofNullable(groupOfStopPlaces.getName().getValue());
        } else {
            this.issueStore.add("GroupOfStopPlacesWithoutName", "GroupOfStopPlaces {} does not contain a name.", groupOfStopPlaces.getId());
            StopPlaceRefStructure ref = (StopPlaceRefStructure)groupOfStopPlaces.getMembers().getStopPlaceRef().get(0);
            name = this.stations.get(this.idFactory.createId(ref.getRef())).getName();
        }
        GroupOfStationsBuilder groupOfStations = GroupOfStations.of(this.idFactory.createId(groupOfStopPlaces.getId())).withName(name);
        WgsCoordinate coordinate = WgsCoordinateMapper.mapToDomain(groupOfStopPlaces.getCentroid());
        if (coordinate == null) {
            this.issueStore.add("GroupOfStationWithoutCoordinates", "MultiModal station {} does not contain any coordinates.", groupOfStations.getId());
        } else {
            groupOfStations.withCoordinate(coordinate);
        }
        this.connectChildStation(groupOfStopPlaces, groupOfStations);
        return (GroupOfStations)groupOfStations.build();
    }

    private void connectChildStation(GroupOfStopPlaces groupOfStopPlaces, GroupOfStationsBuilder groupOfStations) {
        StopPlaceRefs_RelStructure members = groupOfStopPlaces.getMembers();
        if (members != null) {
            List memberList = members.getStopPlaceRef();
            for (StopPlaceRefStructure stopPlaceRefStructure : memberList) {
                FeedScopedId stationId = this.idFactory.createId(stopPlaceRefStructure.getRef());
                StopLocationsGroup station = this.lookupStation(stationId);
                if (station != null) {
                    groupOfStations.addChildStation(station);
                    continue;
                }
                this.issueStore.add("GroupOfStationWithoutStations", "GroupOfStation %s child not found: %s", groupOfStations.getId(), stationId);
            }
        }
    }

    @Nullable
    private StopLocationsGroup lookupStation(FeedScopedId stationId) {
        if (this.stations.containsKey(stationId)) {
            return this.stations.get(stationId);
        }
        if (this.multiModalStations.containsKey(stationId)) {
            return this.multiModalStations.get(stationId);
        }
        return null;
    }
}

