/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.configure;

import java.util.ArrayList;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.graph_builder.ConfiguredDataSource;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.netex.NetexBundle;
import org.opentripplanner.netex.NetexModule;
import org.opentripplanner.netex.config.NetexFeedParameters;
import org.opentripplanner.netex.loader.NetexDataSourceHierarchy;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.transit.service.TransitModel;

public class NetexConfigure {
    private final BuildConfig buildParams;

    public NetexConfigure(BuildConfig builderParams) {
        this.buildParams = builderParams;
    }

    public NetexModule createNetexModule(Iterable<ConfiguredDataSource<NetexFeedParameters>> netexSources, TransitModel transitModel, Graph graph, DataImportIssueStore issueStore) {
        ArrayList<NetexBundle> netexBundles = new ArrayList<NetexBundle>();
        for (ConfiguredDataSource<NetexFeedParameters> it : netexSources) {
            netexBundles.add(this.netexBundle(it));
        }
        return new NetexModule(graph, transitModel, issueStore, this.buildParams.getSubwayAccessTimeSeconds(), this.buildParams.getTransitServicePeriod(), netexBundles);
    }

    public NetexBundle netexBundle(ConfiguredDataSource<NetexFeedParameters> configuredDataSource) {
        CompositeDataSource source = (CompositeDataSource)configuredDataSource.dataSource();
        NetexFeedParameters config = configuredDataSource.config();
        return new NetexBundle(config.feedId(), source, this.hierarchy(source, config), config.ferryIdsNotAllowedForBicycle(), this.buildParams.maxStopToShapeSnapDistance, config.noTransfersOnIsolatedStops(), config.ignoreFareFrame());
    }

    private NetexDataSourceHierarchy hierarchy(CompositeDataSource source, NetexFeedParameters params) {
        return new NetexDataSourceHierarchy(source).prepare(params.ignoreFilePattern(), params.sharedFilePattern(), params.sharedGroupFilePattern(), params.groupFilePattern());
    }
}

