/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.config;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.graph_builder.model.DataSourceConfig;

public class NetexFeedParameters
implements DataSourceConfig {
    private static final String NETEX_FEED_ID = "NETEX";
    private static final String EMPTY_STRING_PATTERN = "$^";
    private static final String IGNORE_FILE_PATTERN = "$^";
    private static final String SHARED_FILE_PATTERN = "shared-data\\.xml";
    private static final String SHARED_GROUP_FILE_PATTERN = "(\\w{3})-.*-shared\\.xml";
    private static final String GROUP_FILE_PATTERN = "(\\w{3})-.*\\.xml";
    private static final boolean NO_TRANSFERS_ON_ISOLATED_STOPS = false;
    private static final boolean IGNORE_FARE_FRAME = false;
    private static final Set<String> FERRY_IDS_NOT_ALLOWED_FOR_BICYCLE = Collections.emptySet();
    public static final NetexFeedParameters DEFAULT = new NetexFeedParameters();
    private final URI source;
    private final String feedId;
    private final String sharedFilePattern;
    private final String sharedGroupFilePattern;
    private final String groupFilePattern;
    private final String ignoreFilePattern;
    private final Set<String> ferryIdsNotAllowedForBicycle;
    private final boolean noTransfersOnIsolatedStops;
    private final boolean ignoreFareFrame;

    private NetexFeedParameters() {
        this.source = null;
        this.feedId = NETEX_FEED_ID;
        this.sharedFilePattern = Pattern.compile(SHARED_FILE_PATTERN).pattern();
        this.sharedGroupFilePattern = Pattern.compile(SHARED_GROUP_FILE_PATTERN).pattern();
        this.groupFilePattern = Pattern.compile(GROUP_FILE_PATTERN).pattern();
        this.ignoreFilePattern = Pattern.compile("$^").pattern();
        this.ferryIdsNotAllowedForBicycle = FERRY_IDS_NOT_ALLOWED_FOR_BICYCLE;
        this.noTransfersOnIsolatedStops = false;
        this.ignoreFareFrame = false;
    }

    private NetexFeedParameters(Builder builder) {
        this.source = builder.source;
        this.feedId = Objects.requireNonNull(builder.feedId);
        this.sharedFilePattern = Objects.requireNonNull(builder.sharedFilePattern);
        this.sharedGroupFilePattern = Objects.requireNonNull(builder.sharedGroupFilePattern);
        this.groupFilePattern = Objects.requireNonNull(builder.groupFilePattern);
        this.ignoreFilePattern = Objects.requireNonNull(builder.ignoreFilePattern);
        this.ferryIdsNotAllowedForBicycle = Set.copyOf(builder.ferryIdsNotAllowedForBicycle);
        this.noTransfersOnIsolatedStops = builder.noTransfersOnIsolatedStops;
        this.ignoreFareFrame = builder.ignoreFareFrame;
    }

    public static Builder of() {
        return DEFAULT.copyOf();
    }

    public Builder copyOf() {
        return new Builder(this);
    }

    @Override
    public URI source() {
        return this.source;
    }

    public String feedId() {
        return this.feedId;
    }

    public Pattern sharedFilePattern() {
        return Pattern.compile(this.sharedFilePattern);
    }

    public Pattern sharedGroupFilePattern() {
        return Pattern.compile(this.sharedGroupFilePattern);
    }

    public Pattern groupFilePattern() {
        return Pattern.compile(this.groupFilePattern);
    }

    public Pattern ignoreFilePattern() {
        return Pattern.compile(this.ignoreFilePattern);
    }

    public Set<String> ferryIdsNotAllowedForBicycle() {
        return this.ferryIdsNotAllowedForBicycle;
    }

    public boolean noTransfersOnIsolatedStops() {
        return this.noTransfersOnIsolatedStops;
    }

    public boolean ignoreFareFrame() {
        return this.ignoreFareFrame;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetexFeedParameters that = (NetexFeedParameters)o;
        return Objects.equals(this.source, that.source) && this.feedId.equals(that.feedId) && this.ignoreFilePattern.equals(that.ignoreFilePattern) && this.sharedFilePattern.equals(that.sharedFilePattern) && this.sharedGroupFilePattern.equals(that.sharedGroupFilePattern) && this.groupFilePattern.equals(that.groupFilePattern) && this.ignoreFareFrame == that.ignoreFareFrame && this.ferryIdsNotAllowedForBicycle.equals(that.ferryIdsNotAllowedForBicycle);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.feedId, this.ignoreFilePattern, this.sharedFilePattern, this.sharedGroupFilePattern, this.groupFilePattern, this.ignoreFareFrame, this.ferryIdsNotAllowedForBicycle);
    }

    public String toString() {
        return ToStringBuilder.of(NetexFeedParameters.class).addObj("source", this.source, null).addObj("feedId", this.feedId, NetexFeedParameters.DEFAULT.feedId).addStr("sharedFilePattern", this.sharedFilePattern, NetexFeedParameters.DEFAULT.sharedFilePattern).addStr("sharedGroupFilePattern", this.sharedGroupFilePattern, NetexFeedParameters.DEFAULT.sharedGroupFilePattern).addStr("groupFilePattern", this.groupFilePattern, NetexFeedParameters.DEFAULT.groupFilePattern).addStr("ignoreFilePattern", this.ignoreFilePattern, NetexFeedParameters.DEFAULT.ignoreFilePattern).addBoolIfTrue("ignoreFareFrame", this.ignoreFareFrame).addCol("ferryIdsNotAllowedForBicycle", this.ferryIdsNotAllowedForBicycle, Set.of()).toString();
    }

    public static class Builder {
        private final NetexFeedParameters original;
        private URI source;
        private String feedId;
        private String sharedFilePattern;
        private String sharedGroupFilePattern;
        private String groupFilePattern;
        private String ignoreFilePattern;
        private final Set<String> ferryIdsNotAllowedForBicycle = new HashSet<String>();
        private boolean noTransfersOnIsolatedStops;
        private boolean ignoreFareFrame;

        private Builder(NetexFeedParameters original) {
            this.original = original;
            this.source = original.source();
            this.feedId = original.feedId();
            this.sharedFilePattern = original.sharedFilePattern;
            this.sharedGroupFilePattern = original.sharedGroupFilePattern;
            this.groupFilePattern = original.groupFilePattern;
            this.ignoreFilePattern = original.ignoreFilePattern;
            this.ferryIdsNotAllowedForBicycle.addAll(original.ferryIdsNotAllowedForBicycle);
            this.noTransfersOnIsolatedStops = original.noTransfersOnIsolatedStops;
            this.ignoreFareFrame = original.ignoreFareFrame;
        }

        public URI source() {
            return this.source;
        }

        public Builder withSource(URI source) {
            this.source = source;
            return this;
        }

        public Builder withFeedId(String feedId) {
            this.feedId = feedId;
            return this;
        }

        public Builder withSharedFilePattern(Pattern sharedFilePattern) {
            this.sharedFilePattern = sharedFilePattern.pattern();
            return this;
        }

        public Builder withSharedGroupFilePattern(Pattern sharedGroupFilePattern) {
            this.sharedGroupFilePattern = sharedGroupFilePattern.pattern();
            return this;
        }

        public Builder withGroupFilePattern(Pattern groupFilePattern) {
            this.groupFilePattern = groupFilePattern.pattern();
            return this;
        }

        public Builder withIgnoreFilePattern(Pattern ignoreFilePattern) {
            this.ignoreFilePattern = ignoreFilePattern.pattern();
            return this;
        }

        public Builder addFerryIdsNotAllowedForBicycle(Collection<String> ferryId) {
            this.ferryIdsNotAllowedForBicycle.addAll(ferryId);
            return this;
        }

        public Builder withNoTransfersOnIsolatedStops(boolean noTransfersOnIsolatedStops) {
            this.noTransfersOnIsolatedStops = noTransfersOnIsolatedStops;
            return this;
        }

        public Builder withIgnoreFareFrame(boolean ignoreFareFrame) {
            this.ignoreFareFrame = ignoreFareFrame;
            return this;
        }

        public NetexFeedParameters build() {
            NetexFeedParameters value = new NetexFeedParameters(this);
            return this.original.equals(value) ? this.original : value;
        }
    }
}

