/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.transfer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.model.transfer.RouteStationTransferPoint;
import org.opentripplanner.model.transfer.RouteStopTransferPoint;
import org.opentripplanner.model.transfer.StationTransferPoint;
import org.opentripplanner.model.transfer.StopTransferPoint;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.model.transfer.TripTransferPoint;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;

class TransferPointMap<E> {
    private final Map<TripKey, E> tripMap = new HashMap<TripKey, E>();
    private final Map<RouteStopKey, E> routeStopMap = new HashMap<RouteStopKey, E>();
    private final Map<RouteStationKey, E> routeStationMap = new HashMap<RouteStationKey, E>();
    private final Map<StopLocation, E> stopMap = new HashMap<StopLocation, E>();
    private final Map<Station, E> stationMap = new HashMap<Station, E>();

    TransferPointMap() {
    }

    void put(TransferPoint point, E e) {
        if (point.isTripTransferPoint()) {
            TripTransferPoint tp = point.asTripTransferPoint();
            this.tripMap.put(new TripKey(tp.getTrip(), tp.getStopPositionInPattern()), e);
        } else if (point.isRouteStopTransferPoint()) {
            RouteStopTransferPoint rp = point.asRouteStopTransferPoint();
            this.routeStopMap.put(new RouteStopKey(rp.getRoute(), rp.getStop()), e);
        } else if (point.isRouteStationTransferPoint()) {
            RouteStationTransferPoint rp = point.asRouteStationTransferPoint();
            this.routeStationMap.put(new RouteStationKey(rp.getRoute(), rp.getStation()), e);
        } else if (point.isStopTransferPoint()) {
            this.stopMap.put(point.asStopTransferPoint().getStop(), e);
        } else if (point.isStationTransferPoint()) {
            this.stationMap.put(point.asStationTransferPoint().getStation(), e);
        } else {
            throw new IllegalArgumentException("Unknown TransferPoint type: " + point);
        }
    }

    E computeIfAbsent(TransferPoint point, Supplier<E> creator) {
        if (point.isTripTransferPoint()) {
            TripTransferPoint tp = point.asTripTransferPoint();
            return (E)this.tripMap.computeIfAbsent(new TripKey(tp.getTrip(), tp.getStopPositionInPattern()), (? super K k) -> creator.get());
        }
        if (point.isRouteStopTransferPoint()) {
            RouteStopTransferPoint rp = point.asRouteStopTransferPoint();
            return (E)this.routeStopMap.computeIfAbsent(new RouteStopKey(rp.getRoute(), rp.getStop()), (? super K k) -> creator.get());
        }
        if (point.isRouteStationTransferPoint()) {
            RouteStationTransferPoint rp = point.asRouteStationTransferPoint();
            return (E)this.routeStationMap.computeIfAbsent(new RouteStationKey(rp.getRoute(), rp.getStation()), (? super K k) -> creator.get());
        }
        if (point.isStopTransferPoint()) {
            StopTransferPoint sp = point.asStopTransferPoint();
            return (E)this.stopMap.computeIfAbsent(sp.getStop(), (? super K k) -> creator.get());
        }
        if (point.isStationTransferPoint()) {
            StationTransferPoint sp = point.asStationTransferPoint();
            return (E)this.stationMap.computeIfAbsent(sp.getStation(), (? super K k) -> creator.get());
        }
        throw new IllegalArgumentException("Unknown TransferPoint type: " + point);
    }

    List<E> get(Trip trip, StopLocation stop, int stopPointInPattern) {
        return Stream.of(this.tripMap.get(new TripKey(trip, stopPointInPattern)), this.routeStopMap.get(new RouteStopKey(trip.getRoute(), stop)), this.routeStationMap.get(new RouteStationKey(trip.getRoute(), stop.getParentStation())), this.stopMap.get(stop), this.stationMap.get(stop.getParentStation())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private record TripKey(Trip trip, int stopPositionInPattern) {
    }

    private record RouteStopKey(Route route, StopLocation stop) {
    }

    private record RouteStationKey(Route route, Station station) {
    }
}

