/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.model.plan.ElevationProfile;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.street.model.note.StreetNote;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class StreetLegBuilder {
    private TraverseMode mode;
    private ZonedDateTime startTime;
    private ZonedDateTime endTime;
    private Place from;
    private Place to;
    private double distanceMeters;
    private int generalizedCost;
    private LineString geometry;
    private ElevationProfile elevationProfile;
    private List<WalkStep> walkSteps;
    private FeedScopedId pathwayId;
    private Boolean walkingBike;
    private Boolean rentedVehicle;
    private String vehicleRentalNetwork;
    private Float accessibilityScore;
    private Set<StreetNote> streetNotes = new HashSet<StreetNote>();

    protected StreetLegBuilder() {
    }

    public static StreetLegBuilder of(StreetLeg leg) {
        return new StreetLegBuilder().withMode(leg.getMode()).withStartTime(leg.getStartTime()).withEndTime(leg.getEndTime()).withFrom(leg.getFrom()).withTo(leg.getTo()).withDistanceMeters(leg.getDistanceMeters()).withGeneralizedCost(leg.getGeneralizedCost()).withGeometry(leg.getLegGeometry()).withElevationProfile(leg.getElevationProfile()).withWalkSteps(leg.getWalkSteps()).withPathwayId(leg.getPathwayId()).withWalkingBike(leg.getWalkingBike()).withRentedVehicle(leg.getRentedVehicle()).withVehicleRentalNetwork(leg.getVehicleRentalNetwork()).withAccessibilityScore(leg.accessibilityScore()).withStreetNotes(leg.getStreetNotes());
    }

    public StreetLeg build() {
        return new StreetLeg(this);
    }

    public TraverseMode getMode() {
        return this.mode;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public ZonedDateTime getEndTime() {
        return this.endTime;
    }

    public Place getFrom() {
        return this.from;
    }

    public Place getTo() {
        return this.to;
    }

    public double getDistanceMeters() {
        return this.distanceMeters;
    }

    public int getGeneralizedCost() {
        return this.generalizedCost;
    }

    public LineString getGeometry() {
        return this.geometry;
    }

    public ElevationProfile getElevationProfile() {
        return this.elevationProfile;
    }

    public List<WalkStep> getWalkSteps() {
        return this.walkSteps;
    }

    public FeedScopedId getPathwayId() {
        return this.pathwayId;
    }

    public Boolean getWalkingBike() {
        return this.walkingBike;
    }

    public Boolean getRentedVehicle() {
        return this.rentedVehicle;
    }

    public String getVehicleRentalNetwork() {
        return this.vehicleRentalNetwork;
    }

    public Float getAccessibilityScore() {
        return this.accessibilityScore;
    }

    public Set<StreetNote> getStreetNotes() {
        return this.streetNotes;
    }

    public StreetLegBuilder withMode(TraverseMode mode) {
        this.mode = mode;
        return this;
    }

    public StreetLegBuilder withStartTime(ZonedDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public StreetLegBuilder withEndTime(ZonedDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public StreetLegBuilder withFrom(Place from) {
        this.from = from;
        return this;
    }

    public StreetLegBuilder withTo(Place to) {
        this.to = to;
        return this;
    }

    public StreetLegBuilder withDistanceMeters(double distanceMeters) {
        this.distanceMeters = distanceMeters;
        return this;
    }

    public StreetLegBuilder withGeneralizedCost(int generalizedCost) {
        this.generalizedCost = generalizedCost;
        return this;
    }

    public StreetLegBuilder withGeometry(LineString geometry) {
        this.geometry = geometry;
        return this;
    }

    public StreetLegBuilder withElevationProfile(ElevationProfile elevationProfile) {
        this.elevationProfile = elevationProfile;
        return this;
    }

    public StreetLegBuilder withWalkSteps(List<WalkStep> walkSteps) {
        this.walkSteps = walkSteps;
        return this;
    }

    public StreetLegBuilder withPathwayId(FeedScopedId pathwayId) {
        this.pathwayId = pathwayId;
        return this;
    }

    public StreetLegBuilder withWalkingBike(Boolean walkingBike) {
        this.walkingBike = walkingBike;
        return this;
    }

    public StreetLegBuilder withRentedVehicle(Boolean rentedVehicle) {
        this.rentedVehicle = rentedVehicle;
        return this;
    }

    public StreetLegBuilder withVehicleRentalNetwork(String vehicleRentalNetwork) {
        this.vehicleRentalNetwork = vehicleRentalNetwork;
        return this;
    }

    public StreetLegBuilder withAccessibilityScore(Float accessibilityScore) {
        this.accessibilityScore = accessibilityScore;
        return this;
    }

    public StreetLegBuilder withStreetNotes(Set<StreetNote> notes) {
        this.streetNotes = Set.copyOf(notes);
        return this;
    }
}

