/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.lang.DoubleUtils;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.model.plan.legreference.LegReference;
import org.opentripplanner.model.plan.legreference.ScheduledTransitLegReference;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;

public class ScheduledTransitLeg
implements TransitLeg {
    protected final TripTimes tripTimes;
    protected final TripPattern tripPattern;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final LineString legGeometry;
    private final Set<TransitAlert> transitAlerts = new HashSet<TransitAlert>();
    private final ConstrainedTransfer transferFromPrevLeg;
    private final ConstrainedTransfer transferToNextLeg;
    protected final Integer boardStopPosInPattern;
    protected final Integer alightStopPosInPattern;
    private final int generalizedCost;
    protected final LocalDate serviceDate;
    protected final ZoneId zoneId;
    private double distanceMeters;
    private double directDistanceMeters;
    private final Float accessibilityScore;

    public ScheduledTransitLeg(TripTimes tripTimes, TripPattern tripPattern, int boardStopIndexInPattern, int alightStopIndexInPattern, ZonedDateTime startTime, ZonedDateTime endTime, LocalDate serviceDate, ZoneId zoneId, ConstrainedTransfer transferFromPreviousLeg, ConstrainedTransfer transferToNextLeg, int generalizedCost, @Nullable Float accessibilityScore) {
        this.tripTimes = tripTimes;
        this.tripPattern = tripPattern;
        this.boardStopPosInPattern = boardStopIndexInPattern;
        this.alightStopPosInPattern = alightStopIndexInPattern;
        this.startTime = startTime;
        this.endTime = endTime;
        this.serviceDate = serviceDate;
        this.zoneId = zoneId;
        this.transferFromPrevLeg = transferFromPreviousLeg;
        this.transferToNextLeg = transferToNextLeg;
        this.generalizedCost = generalizedCost;
        this.accessibilityScore = accessibilityScore;
        List<Coordinate> transitLegCoordinates = this.extractTransitLegCoordinates(tripPattern, boardStopIndexInPattern, alightStopIndexInPattern);
        this.legGeometry = GeometryUtils.makeLineString(transitLegCoordinates);
        this.setDistanceMeters(this.getDistanceFromCoordinates(transitLegCoordinates));
        this.directDistanceMeters = this.getDistanceFromCoordinates(List.of(transitLegCoordinates.get(0), transitLegCoordinates.get(transitLegCoordinates.size() - 1)));
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public TripTimes getTripTimes() {
        return this.tripTimes;
    }

    public TripPattern getTripPattern() {
        return this.tripPattern;
    }

    public Instant getServiceDateMidnight() {
        return ServiceDateUtils.asStartOfService(this.serviceDate, this.zoneId).toInstant();
    }

    @Override
    public boolean isScheduledTransitLeg() {
        return true;
    }

    @Override
    public ScheduledTransitLeg asScheduledTransitLeg() {
        return this;
    }

    @Override
    public Boolean isInterlinedWithPreviousLeg() {
        if (this.transferFromPrevLeg == null) {
            return false;
        }
        return this.transferFromPrevLeg.getTransferConstraint().isStaySeated();
    }

    @Override
    public Agency getAgency() {
        return this.getTrip().getRoute().getAgency();
    }

    @Override
    public Operator getOperator() {
        return this.getTrip().getOperator();
    }

    @Override
    public Route getRoute() {
        return this.getTrip().getRoute();
    }

    @Override
    public Trip getTrip() {
        return this.tripTimes.getTrip();
    }

    @Override
    public Accessibility getTripWheelchairAccessibility() {
        return this.tripTimes.getWheelchairAccessibility();
    }

    @Override
    @Nonnull
    public TransitMode getMode() {
        return this.getTrip().getMode();
    }

    @Override
    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public ZonedDateTime getEndTime() {
        return this.endTime;
    }

    @Override
    public int getDepartureDelay() {
        return this.tripTimes.isCancelledStop(this.boardStopPosInPattern) || this.tripTimes.isNoDataStop(this.boardStopPosInPattern) ? 0 : this.tripTimes.getDepartureDelay(this.boardStopPosInPattern);
    }

    @Override
    public int getArrivalDelay() {
        return this.tripTimes.isCancelledStop(this.alightStopPosInPattern) || this.tripTimes.isNoDataStop(this.alightStopPosInPattern) ? 0 : this.tripTimes.getArrivalDelay(this.alightStopPosInPattern);
    }

    @Override
    public boolean getRealTime() {
        return !this.tripTimes.isScheduled() && (!this.tripTimes.isNoDataStop(this.boardStopPosInPattern) || !this.tripTimes.isNoDataStop(this.alightStopPosInPattern));
    }

    @Override
    public double getDistanceMeters() {
        return this.distanceMeters;
    }

    protected void setDistanceMeters(double distanceMeters) {
        this.distanceMeters = DoubleUtils.roundTo2Decimals(distanceMeters);
    }

    public double getDirectDistanceMeters() {
        return this.directDistanceMeters;
    }

    @Override
    public Integer getRouteType() {
        return this.getTrip().getRoute().getGtfsType();
    }

    @Override
    public I18NString getHeadsign() {
        return this.tripTimes.getHeadsign(this.boardStopPosInPattern);
    }

    @Override
    public LocalDate getServiceDate() {
        return this.serviceDate;
    }

    @Override
    public Place getFrom() {
        return Place.forStop(this.tripPattern.getStop(this.boardStopPosInPattern));
    }

    @Override
    public Place getTo() {
        return Place.forStop(this.tripPattern.getStop(this.alightStopPosInPattern));
    }

    @Override
    public List<StopArrival> getIntermediateStops() {
        ArrayList<StopArrival> visits = new ArrayList<StopArrival>();
        for (int i = this.boardStopPosInPattern + 1; i < this.alightStopPosInPattern; ++i) {
            StopLocation stop = this.tripPattern.getStop(i);
            StopArrival visit = new StopArrival(Place.forStop(stop), ServiceDateUtils.toZonedDateTime(this.serviceDate, this.zoneId, this.tripTimes.getArrivalTime(i)), ServiceDateUtils.toZonedDateTime(this.serviceDate, this.zoneId, this.tripTimes.getDepartureTime(i)), i, this.tripTimes.getOriginalGtfsStopSequence(i));
            visits.add(visit);
        }
        return visits;
    }

    @Override
    public LineString getLegGeometry() {
        return this.legGeometry;
    }

    @Override
    public Set<TransitAlert> getTransitAlerts() {
        return this.transitAlerts;
    }

    @Override
    public PickDrop getBoardRule() {
        if (this.transferFromPrevLeg != null && this.transferFromPrevLeg.getTransferConstraint().isStaySeated()) {
            return null;
        }
        return this.tripPattern.getBoardType(this.boardStopPosInPattern);
    }

    @Override
    public PickDrop getAlightRule() {
        if (this.transferToNextLeg != null && this.transferToNextLeg.getTransferConstraint().isStaySeated()) {
            return null;
        }
        return this.tripPattern.getAlightType(this.alightStopPosInPattern);
    }

    @Override
    public BookingInfo getDropOffBookingInfo() {
        return this.tripTimes.getDropOffBookingInfo(this.alightStopPosInPattern);
    }

    @Override
    public BookingInfo getPickupBookingInfo() {
        return this.tripTimes.getPickupBookingInfo(this.boardStopPosInPattern);
    }

    @Override
    public ConstrainedTransfer getTransferFromPrevLeg() {
        return this.transferFromPrevLeg;
    }

    @Override
    public ConstrainedTransfer getTransferToNextLeg() {
        return this.transferToNextLeg;
    }

    @Override
    public Integer getBoardStopPosInPattern() {
        return this.boardStopPosInPattern;
    }

    @Override
    public Integer getAlightStopPosInPattern() {
        return this.alightStopPosInPattern;
    }

    @Override
    public Integer getBoardingGtfsStopSequence() {
        return this.tripTimes.getOriginalGtfsStopSequence(this.boardStopPosInPattern);
    }

    @Override
    public Integer getAlightGtfsStopSequence() {
        return this.tripTimes.getOriginalGtfsStopSequence(this.alightStopPosInPattern);
    }

    @Override
    public int getGeneralizedCost() {
        return this.generalizedCost;
    }

    @Override
    public LegReference getLegReference() {
        return new ScheduledTransitLegReference(this.tripTimes.getTrip().getId(), this.serviceDate, this.boardStopPosInPattern, this.alightStopPosInPattern);
    }

    @Override
    public void addAlert(TransitAlert alert) {
        this.transitAlerts.add(alert);
    }

    @Override
    @Nullable
    public Float accessibilityScore() {
        return this.accessibilityScore;
    }

    public ScheduledTransitLeg withAccessibilityScore(Float score) {
        return new ScheduledTransitLeg(this.tripTimes, this.tripPattern, this.boardStopPosInPattern, this.alightStopPosInPattern, this.startTime, this.endTime, this.serviceDate, this.zoneId, this.transferFromPrevLeg, this.transferToNextLeg, this.generalizedCost, score);
    }

    public String toString() {
        return ToStringBuilder.of(ScheduledTransitLeg.class).addObj("from", this.getFrom()).addObj("to", this.getTo()).addTime("startTime", this.startTime).addTime("endTime", this.endTime).addBool("realTime", this.getRealTime()).addNum("distance", (Number)this.distanceMeters, "m").addNum("cost", this.generalizedCost).addNum("routeType", this.getRouteType()).addObjOp("agencyId", this.getAgency(), AbstractTransitEntity::getId).addObjOp("routeId", this.getRoute(), AbstractTransitEntity::getId).addObjOp("tripId", this.getTrip(), AbstractTransitEntity::getId).addObj("headsign", this.getHeadsign()).addObj("serviceDate", this.serviceDate).addObj("legGeometry", this.legGeometry).addCol("transitAlerts", this.transitAlerts).addEnum("boardRule", this.getBoardRule()).addEnum("alightRule", this.getAlightRule()).addObj("transferFromPrevLeg", this.transferFromPrevLeg).addObj("transferToNextLeg", this.transferToNextLeg).toString();
    }

    private List<Coordinate> extractTransitLegCoordinates(TripPattern tripPattern, int boardStopIndexInPattern, int alightStopIndexInPattern) {
        ArrayList<Coordinate> transitLegCoordinates = new ArrayList<Coordinate>();
        for (int i = boardStopIndexInPattern + 1; i <= alightStopIndexInPattern; ++i) {
            transitLegCoordinates.addAll(Arrays.asList(tripPattern.getHopGeometry(i - 1).getCoordinates()));
        }
        return transitLegCoordinates;
    }

    private double getDistanceFromCoordinates(List<Coordinate> coordinates) {
        double distance = 0.0;
        for (int i = 1; i < coordinates.size(); ++i) {
            distance += SphericalDistanceLibrary.distance(coordinates.get(i), coordinates.get(i - 1));
        }
        return distance;
    }
}

