/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar.openinghours;

import java.io.Serializable;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.Objects;
import org.opentripplanner.framework.time.TimeUtils;

public class OpeningHours
implements Comparable<OpeningHours>,
Serializable {
    private final String periodDescription;
    private final int startTime;
    private final int endTime;
    private final BitSet days;

    OpeningHours(String periodDescription, LocalTime startTime, LocalTime endTime, BitSet days) {
        this.periodDescription = periodDescription;
        this.startTime = startTime.toSecondOfDay();
        this.endTime = endTime.toSecondOfDay();
        this.days = days;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpeningHours)) {
            return false;
        }
        OpeningHours that = (OpeningHours)o;
        return this.startTime == that.startTime && this.endTime == that.endTime && this.days.equals(that.days);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.days);
    }

    public String toString() {
        return this.periodDescription + " " + TimeUtils.timeToStrCompact(this.startTime) + "-" + TimeUtils.timeToStrCompact(this.endTime);
    }

    @Override
    public int compareTo(OpeningHours other) {
        return this.startTime == other.startTime ? this.endTime - other.endTime : this.startTime - other.startTime;
    }

    public boolean contains(OpeningHours other) {
        return this.startTime <= other.startTime && other.endTime <= this.endTime;
    }

    public boolean isOpen(int day, int secondsSinceMidnight) {
        return this.days.get(day) && this.startTime <= secondsSinceMidnight && secondsSinceMidnight <= this.endTime;
    }

    public String periodDescription() {
        return this.periodDescription;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }
}

