/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.OccupancyStatus;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.StopTimeKey;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripTimeOnDate {
    private static final Logger LOG = LoggerFactory.getLogger(TripTimeOnDate.class);
    public static final int UNDEFINED = -1;
    private final TripTimes tripTimes;
    private final int stopIndex;
    private final TripPattern tripPattern;
    private final LocalDate serviceDate;
    private final long midnight;

    public TripTimeOnDate(TripTimes tripTimes, int stopIndex, TripPattern tripPattern) {
        this.tripTimes = tripTimes;
        this.stopIndex = stopIndex;
        this.tripPattern = tripPattern;
        this.serviceDate = null;
        this.midnight = -1L;
    }

    public TripTimeOnDate(TripTimes tripTimes, int stopIndex, TripPattern tripPattern, LocalDate serviceDate, Instant midnight) {
        this.tripTimes = tripTimes;
        this.stopIndex = stopIndex;
        this.tripPattern = tripPattern;
        this.serviceDate = serviceDate;
        this.midnight = midnight != null ? midnight.getEpochSecond() : -1L;
    }

    public static List<TripTimeOnDate> fromTripTimes(Timetable table, Trip trip) {
        TripTimes times = table.getTripTimes(trip);
        ArrayList<TripTimeOnDate> out = new ArrayList<TripTimeOnDate>();
        for (int i = 0; i < times.getNumStops(); ++i) {
            out.add(new TripTimeOnDate(times, i, table.getPattern()));
        }
        return out;
    }

    public static List<TripTimeOnDate> fromTripTimes(Timetable table, Trip trip, LocalDate serviceDate, Instant midnight) {
        TripTimes times = table.getTripTimes(trip);
        ArrayList<TripTimeOnDate> out = new ArrayList<TripTimeOnDate>();
        for (int i = 0; i < times.getNumStops(); ++i) {
            out.add(new TripTimeOnDate(times, i, table.getPattern(), serviceDate, midnight));
        }
        return out;
    }

    public static Comparator<TripTimeOnDate> compareByDeparture() {
        return Comparator.comparing(t -> t.getServiceDayMidnight() + (long)t.getRealtimeDeparture());
    }

    public StopLocation getStop() {
        return this.tripPattern.getStop(this.stopIndex);
    }

    public int getStopIndex() {
        return this.stopIndex;
    }

    public TripTimes getTripTimes() {
        return this.tripTimes;
    }

    public int getStopCount() {
        return this.tripTimes.getNumStops();
    }

    public int getScheduledArrival() {
        return this.tripTimes.getScheduledArrivalTime(this.stopIndex);
    }

    public int getScheduledDeparture() {
        return this.tripTimes.getScheduledDepartureTime(this.stopIndex);
    }

    public int getRealtimeArrival() {
        return this.isCancelledStop() || this.isNoDataStop() ? this.tripTimes.getScheduledArrivalTime(this.stopIndex) : this.tripTimes.getArrivalTime(this.stopIndex);
    }

    public int getRealtimeDeparture() {
        return this.isCancelledStop() || this.isNoDataStop() ? this.tripTimes.getScheduledDepartureTime(this.stopIndex) : this.tripTimes.getDepartureTime(this.stopIndex);
    }

    public int getActualArrival() {
        return this.tripTimes.isRecordedStop(this.stopIndex) ? this.tripTimes.getArrivalTime(this.stopIndex) : -1;
    }

    public int getActualDeparture() {
        return this.tripTimes.isRecordedStop(this.stopIndex) ? this.tripTimes.getDepartureTime(this.stopIndex) : -1;
    }

    public int getArrivalDelay() {
        return this.isCancelledStop() || this.isNoDataStop() ? 0 : this.tripTimes.getArrivalDelay(this.stopIndex);
    }

    public int getDepartureDelay() {
        return this.isCancelledStop() || this.isNoDataStop() ? 0 : this.tripTimes.getDepartureDelay(this.stopIndex);
    }

    public boolean isTimepoint() {
        return this.tripTimes.isTimepoint(this.stopIndex);
    }

    public boolean isRealtime() {
        return !this.tripTimes.isScheduled() && !this.isNoDataStop();
    }

    public boolean isCancelledStop() {
        return this.tripTimes.isCancelledStop(this.stopIndex) || this.tripPattern.isBoardAndAlightAt(this.stopIndex, PickDrop.CANCELLED);
    }

    public boolean isPredictionInaccurate() {
        return this.tripTimes.isPredictionInaccurate(this.stopIndex);
    }

    public boolean isCanceledEffectively() {
        return this.isCancelledStop() || this.tripTimes.isCanceledOrDeleted() || this.tripTimes.getTrip().getNetexAlteration().isCanceledOrReplaced();
    }

    public boolean isNoDataStop() {
        return this.tripTimes.isNoDataStop(this.stopIndex);
    }

    public RealTimeState getRealtimeState() {
        return this.tripTimes.isNoDataStop(this.stopIndex) ? RealTimeState.SCHEDULED : this.tripTimes.getRealTimeState();
    }

    public OccupancyStatus getOccupancyStatus() {
        return this.tripTimes.getOccupancyStatus(this.stopIndex);
    }

    public long getServiceDayMidnight() {
        return this.midnight;
    }

    public LocalDate getServiceDay() {
        return this.serviceDate;
    }

    public Trip getTrip() {
        return this.tripTimes.getTrip();
    }

    public String getBlockId() {
        return this.tripTimes.getTrip().getGtfsBlockId();
    }

    public I18NString getHeadsign() {
        return this.tripTimes.getHeadsign(this.stopIndex);
    }

    public List<String> getHeadsignVias() {
        return this.tripTimes.getHeadsignVias(this.stopIndex);
    }

    public PickDrop getPickupType() {
        if (this.tripTimes.isDeleted()) {
            LOG.warn("Returning pickup type for a deleted trip {} on pattern {} on date {}. This indicates a bug.", new Object[]{this.tripTimes.getTrip().getId(), this.tripPattern.getId(), this.serviceDate});
            return this.tripPattern.getBoardType(this.stopIndex);
        }
        return this.tripTimes.isCanceled() || this.tripTimes.isCancelledStop(this.stopIndex) ? PickDrop.CANCELLED : this.tripPattern.getBoardType(this.stopIndex);
    }

    public PickDrop getDropoffType() {
        if (this.tripTimes.isDeleted()) {
            LOG.warn("Returning dropoff type for a deleted trip {} on pattern {} on date {}. This indicates a bug.", new Object[]{this.tripTimes.getTrip().getId(), this.tripPattern.getId(), this.serviceDate});
            return this.tripPattern.getAlightType(this.stopIndex);
        }
        return this.tripTimes.isCanceled() || this.tripTimes.isCancelledStop(this.stopIndex) ? PickDrop.CANCELLED : this.tripPattern.getAlightType(this.stopIndex);
    }

    public StopTimeKey getStopTimeKey() {
        return (StopTimeKey)StopTimeKey.of(this.tripTimes.getTrip().getId(), this.stopIndex).build();
    }

    public BookingInfo getPickupBookingInfo() {
        return this.tripTimes.getPickupBookingInfo(this.stopIndex);
    }

    public BookingInfo getDropOffBookingInfo() {
        return this.tripTimes.getDropOffBookingInfo(this.stopIndex);
    }
}

