/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model;

import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.framework.lang.StringUtils;
import org.opentripplanner.framework.tostring.ValueObjectToStringBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class GenericLocation {
    public final String label;
    public final FeedScopedId stopId;
    public final Double lat;
    public final Double lng;

    public GenericLocation(String label, FeedScopedId stopId, Double lat, Double lng) {
        this.label = label;
        this.stopId = stopId;
        this.lat = lat;
        this.lng = lng;
    }

    public GenericLocation(Double lat, Double lng) {
        this.label = null;
        this.stopId = null;
        this.lat = lat;
        this.lng = lng;
    }

    public static GenericLocation fromStopId(String name, String feedId, String stopId) {
        return new GenericLocation(name, new FeedScopedId(feedId, stopId), null, null);
    }

    @Nullable
    public Coordinate getCoordinate() {
        if (this.lat == null || this.lng == null) {
            return null;
        }
        return new Coordinate(this.lng.doubleValue(), this.lat.doubleValue());
    }

    public boolean isSpecified() {
        return this.stopId != null || this.lat != null && this.lng != null;
    }

    public String toString() {
        ValueObjectToStringBuilder buf = ValueObjectToStringBuilder.of().skipNull();
        if (StringUtils.hasValue(this.label)) {
            buf.addText(this.label);
        }
        buf.addObj(this.stopId);
        buf.addCoordinate(this.lat, this.lng);
        return buf.toString();
    }
}

