/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.vector;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.api.mapping.PropertyMapper;
import org.opentripplanner.inspector.vector.DebugClientAreaStopPropertyMapper;
import org.opentripplanner.inspector.vector.LayerBuilder;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.service.TransitService;

public class AreaStopsLayerBuilder
extends LayerBuilder<AreaStop> {
    private static final Map<MapperType, MapperFactory> mappers = Map.of(MapperType.DebugClient, DebugClientAreaStopPropertyMapper::create);
    private final Function<Envelope, Collection<AreaStop>> findAreaStops = transitService::findAreaStops;

    public AreaStopsLayerBuilder(TransitService transitService, LayerParameters layerParameters, Locale locale) {
        super(mappers.get((Object)MapperType.valueOf(layerParameters.mapper())).build(transitService, locale), layerParameters.name(), layerParameters.expansionFactor());
    }

    @Override
    protected List<Geometry> getGeometries(Envelope query) {
        return this.findAreaStops.apply(query).stream().map(areaStop -> {
            Geometry geometry = areaStop.getGeometry().copy();
            geometry.setUserData(areaStop);
            return geometry;
        }).toList();
    }

    static enum MapperType {
        DebugClient;

    }

    @FunctionalInterface
    private static interface MapperFactory {
        public PropertyMapper<AreaStop> build(TransitService var1, Locale var2);
    }
}

