/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.raster;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.opentripplanner.inspector.raster.AreaEdgeRenderer;
import org.opentripplanner.inspector.raster.BikeSafetyEdgeRenderer;
import org.opentripplanner.inspector.raster.EdgeVertexTileRenderer;
import org.opentripplanner.inspector.raster.ElevationEdgeRenderer;
import org.opentripplanner.inspector.raster.MapTile;
import org.opentripplanner.inspector.raster.NoThruTrafficEdgeRenderer;
import org.opentripplanner.inspector.raster.PathwayEdgeRenderer;
import org.opentripplanner.inspector.raster.TileRenderer;
import org.opentripplanner.inspector.raster.TraversalPermissionsEdgeRenderer;
import org.opentripplanner.inspector.raster.WalkSafetyEdgeRenderer;
import org.opentripplanner.inspector.raster.WheelchairEdgeRenderer;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.graph.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileRendererManager {
    private static final Logger LOG = LoggerFactory.getLogger(TileRendererManager.class);
    private final Map<String, TileRenderer> renderers = new HashMap<String, TileRenderer>();
    private final Graph graph;

    public TileRendererManager(Graph graph, RoutingPreferences routingPreferences) {
        this.graph = graph;
        this.renderers.put("bike-safety", new EdgeVertexTileRenderer(new BikeSafetyEdgeRenderer()));
        this.renderers.put("walk-safety", new EdgeVertexTileRenderer(new WalkSafetyEdgeRenderer()));
        this.renderers.put("thru-traffic", new EdgeVertexTileRenderer(new NoThruTrafficEdgeRenderer()));
        this.renderers.put("traversal", new EdgeVertexTileRenderer(new TraversalPermissionsEdgeRenderer()));
        this.renderers.put("wheelchair", new EdgeVertexTileRenderer(new WheelchairEdgeRenderer(routingPreferences)));
        this.renderers.put("elevation", new EdgeVertexTileRenderer(new ElevationEdgeRenderer(graph)));
        this.renderers.put("pathways", new EdgeVertexTileRenderer(new PathwayEdgeRenderer()));
        this.renderers.put("areas", new EdgeVertexTileRenderer(new AreaEdgeRenderer()));
    }

    public void registerRenderer(String layer, TileRenderer tileRenderer) {
        this.renderers.put(layer, tileRenderer);
    }

    public BufferedImage renderTile(final MapTile mapTile, String layer) {
        TileRenderer.TileRenderContext context = new TileRenderer.TileRenderContext(){

            @Override
            public Envelope expandPixels(double marginXPixels, double marginYPixels) {
                Envelope retval = new Envelope(this.bbox);
                retval.expandBy(marginXPixels / (double)mapTile.width() * (this.bbox.getMaxX() - this.bbox.getMinX()), marginYPixels / (double)mapTile.height() * (this.bbox.getMaxY() - this.bbox.getMinY()));
                return retval;
            }
        };
        context.graph = this.graph;
        TileRenderer renderer = this.renderers.get(layer);
        if (renderer == null) {
            throw new IllegalArgumentException("Unknown layer: " + layer);
        }
        BufferedImage image = new BufferedImage(mapTile.width(), mapTile.height(), renderer.getColorModel());
        context.graphics = image.createGraphics();
        context.bbox = mapTile.bbox();
        context.transform = new AffineTransformation();
        double xScale = (double)mapTile.width() / context.bbox.getWidth();
        double yScale = (double)mapTile.height() / context.bbox.getHeight();
        context.transform.translate(-context.bbox.getMinX(), -context.bbox.getMinY() - context.bbox.getHeight());
        context.transform.scale(xScale, -yScale);
        context.metersPerPixel = Math.toRadians(context.bbox.getHeight()) * 6371000.0 / (double)mapTile.height();
        context.tileWidth = mapTile.width();
        context.tileHeight = mapTile.height();
        long start = System.currentTimeMillis();
        renderer.renderTile(context);
        LOG.debug("Rendered tile at {} in {} ms", (Object)mapTile.bbox(), (Object)(System.currentTimeMillis() - start));
        return image;
    }

    public Map<String, TileRenderer> getRenderers() {
        return this.renderers;
    }
}

