/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.raster;

import java.awt.Color;
import java.util.Optional;
import org.opentripplanner.inspector.raster.EdgeVertexTileRenderer;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.PathwayEdge;
import org.opentripplanner.street.model.vertex.StationElementVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StationElement;

public class PathwayEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    @Override
    public Optional<EdgeVertexTileRenderer.EdgeVisualAttributes> renderEdge(Edge e) {
        Color color;
        if (!(e instanceof PathwayEdge)) {
            return Optional.empty();
        }
        PathwayEdge pwe = (PathwayEdge)e;
        StringBuilder sb = new StringBuilder();
        if (!pwe.hasBogusName()) {
            sb.append("name=").append(pwe.getName()).append(", ");
        }
        if (pwe.getDistanceMeters() != 0.0) {
            sb.append("distance=").append(Math.round(pwe.getDistanceMeters())).append(", ");
        }
        if (pwe.getDistanceIndependentTime() != 0) {
            sb.append("time=").append(pwe.getDistanceIndependentTime()).append(", ");
        }
        if (pwe.getSteps() != 0) {
            sb.append("steps=").append(pwe.getSteps()).append(", ");
        }
        if (!sb.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        switch (pwe.getMode()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case WALKWAY: {
                Color color2 = new Color(145, 217, 38);
                break;
            }
            case STAIRS: {
                Color color2 = Color.CYAN;
                break;
            }
            case MOVING_SIDEWALK: {
                Color color2 = Color.GREEN;
                break;
            }
            case ESCALATOR: {
                Color color2 = Color.BLUE;
                break;
            }
            case ELEVATOR: {
                Color color2 = Color.PINK;
                break;
            }
            case FARE_GATE: {
                Color color2 = Color.RED;
                break;
            }
            case EXIT_GATE: {
                Color color2 = Color.MAGENTA;
                break;
            }
            case UNKNOWN: {
                Color color2 = color = Color.GRAY;
            }
        }
        if (!pwe.isWheelchairAccessible()) {
            color = color.darker();
        }
        return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(color, sb.toString());
    }

    @Override
    public Optional<EdgeVertexTileRenderer.VertexVisualAttributes> renderVertex(Vertex v) {
        RegularStop stop;
        if (!(v instanceof StationElementVertex)) {
            return Optional.empty();
        }
        StationElementVertex stationElementVertex = (StationElementVertex)v;
        StationElement stationElement = stationElementVertex.getStationElement();
        StringBuilder sb = new StringBuilder();
        sb.append(stationElement.getName());
        if (stationElement instanceof RegularStop && (stop = (RegularStop)stationElement).getPlatformCode() != null) {
            sb.append(" [").append(stop.getPlatformCode()).append("]");
        }
        if (stationElement.getCode() != null) {
            sb.append(" (").append(stationElement.getCode()).append(")");
        }
        Color color = switch (stationElement.getClass().getSimpleName()) {
            case "Stop" -> Color.ORANGE;
            case "PathwayNode" -> new Color(217, 38, 145);
            case "Entrance" -> new Color(38, 184, 217);
            case "BoardingArea" -> Color.PINK;
            default -> Color.LIGHT_GRAY;
        };
        return EdgeVertexTileRenderer.VertexVisualAttributes.optional(color, sb.toString());
    }

    @Override
    public String getName() {
        return "Pathways";
    }
}

