/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector.raster;

import java.awt.Color;
import java.util.Optional;
import org.opentripplanner.inspector.raster.DefaultScalarColorPalette;
import org.opentripplanner.inspector.raster.EdgeVertexTileRenderer;
import org.opentripplanner.inspector.raster.ScalarColorPalette;
import org.opentripplanner.service.vehiclerental.street.StreetVehicleRentalLink;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;

public class BikeSafetyEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private static final Color VEHICLE_RENTAL_COLOR_VERTEX = new Color(0.0f, 0.7f, 0.0f);
    private final ScalarColorPalette palette = new DefaultScalarColorPalette(1.0, 3.0, 10.0);

    @Override
    public Optional<EdgeVertexTileRenderer.EdgeVisualAttributes> renderEdge(Edge e) {
        if (e instanceof StreetEdge) {
            StreetEdge pse = (StreetEdge)e;
            if (pse.getPermission().allows(TraverseMode.BICYCLE)) {
                double bikeSafety = pse.getBicycleSafetyFactor();
                return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(this.palette.getColor(bikeSafety), String.format("%.02f", bikeSafety));
            }
            return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(Color.LIGHT_GRAY, "no bikes");
        }
        if (e instanceof StreetVehicleRentalLink) {
            return EdgeVertexTileRenderer.EdgeVisualAttributes.optional(this.palette.getColor(1.0), "link");
        }
        return Optional.empty();
    }

    @Override
    public Optional<EdgeVertexTileRenderer.VertexVisualAttributes> renderVertex(Vertex v) {
        if (v instanceof VehicleRentalPlaceVertex) {
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(VEHICLE_RENTAL_COLOR_VERTEX, v.getDefaultName());
        }
        if (v instanceof IntersectionVertex) {
            return EdgeVertexTileRenderer.VertexVisualAttributes.optional(Color.DARK_GRAY, null);
        }
        return Optional.empty();
    }

    @Override
    public String getName() {
        return "Bike safety";
    }
}

