/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.index;

import jakarta.ws.rs.BadRequestException;
import java.util.HashSet;
import java.util.Set;

class ValidateParameters {
    private final Set<String> errors = new HashSet<String>();

    ValidateParameters() {
    }

    ValidateParameters positiveOrZero(String name, Double value) {
        return this.assertTrue(value >= 0.0, this.pad(name) + " is negative: " + value);
    }

    ValidateParameters withinBounds(String name, Double value, double min, double max) {
        this.notNull(name, value);
        if (value != null) {
            this.assertTrue(value >= min || value <= max, this.pad(name) + " is not within bounds [" + min + ", " + max + "]");
        }
        return this;
    }

    ValidateParameters lessThan(String aName, Double aSmall, String bName, Double bBig) {
        this.notNull(aName, aSmall);
        this.notNull(bName, bBig);
        if (aSmall != null && bBig != null) {
            this.assertTrue(aSmall < bBig, this.pad(aName) + " in not less than " + this.pad(bName));
        }
        return this;
    }

    ValidateParameters notNull(String name, Object value) {
        return this.assertFalse(value == null, this.pad(name) + " is missing");
    }

    ValidateParameters assertTrue(boolean expr, String message) {
        return this.assertFalse(!expr, message);
    }

    ValidateParameters assertFalse(boolean expr, String message) {
        if (expr) {
            this.errors.add(message);
        }
        return this;
    }

    void validate() {
        if (this.errors.isEmpty()) {
            return;
        }
        throw new BadRequestException(String.join((CharSequence)", ", this.errors));
    }

    private String pad(String name) {
        return "'" + name + "'";
    }
}

