/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.onebusaway.csv_entities.schema.annotations.CsvField;
import org.onebusaway.csv_entities.schema.annotations.CsvFieldNameConvention;
import org.onebusaway.csv_entities.schema.annotations.CsvFields;
import org.onebusaway.gtfs.model.FeedInfo;
import org.onebusaway.gtfs.model.Translation;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.i18n.TranslatedString;

final class TranslationHelper {
    private static final String TABLE_FEED_INFO = "feed_info";
    private final Map<String, Map<String, List<Translation>>> translationMap = new HashMap<String, Map<String, List<Translation>>>();
    private String feedLanguage = null;

    TranslationHelper() {
    }

    void importTranslations(Collection<Translation> allTranslations, Collection<FeedInfo> feedInfos) {
        if (feedInfos.iterator().hasNext()) {
            this.feedLanguage = feedInfos.iterator().next().getLang();
        }
        Map<String, List<Translation>> byTableName = allTranslations.stream().collect(Collectors.groupingBy(Translation::getTableName));
        for (Map.Entry<String, List<Translation>> i : byTableName.entrySet()) {
            String tableName = i.getKey();
            if (tableName.equals(TABLE_FEED_INFO)) {
                this.translationMap.put(tableName, i.getValue().stream().collect(Collectors.groupingBy(t -> "")));
                continue;
            }
            this.translationMap.put(tableName + "_by_record", i.getValue().stream().filter(t -> t.getFieldValue() == null).collect(Collectors.groupingBy(t -> t.getRecordSubId() != null ? String.join((CharSequence)"_", t.getRecordId(), t.getRecordSubId()) : t.getRecordId())));
            this.translationMap.put(tableName + "_by_field", i.getValue().stream().filter(t -> t.getFieldValue() != null && t.getRecordId() == null).collect(Collectors.groupingBy(Translation::getFieldValue)));
        }
    }

    @Nullable
    I18NString getTranslation(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nonnull String recordId, @Nullable String defaultValue) {
        return this.getTranslation(clazz, fieldName, recordId, null, defaultValue);
    }

    @Nullable
    I18NString getTranslation(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nonnull String recordId, @Nullable String recordSubId, @Nullable String defaultValue) {
        String key;
        Field field;
        if (defaultValue == null) {
            return null;
        }
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        CsvFields csvFields = field.getDeclaringClass().getAnnotation(CsvFields.class);
        String fileName = csvFields.filename();
        String prefix = csvFields.prefix();
        CsvFieldNameConvention fieldNameConvention = csvFields.fieldNameConvention();
        String csvFieldName = Optional.ofNullable(field.getAnnotation(CsvField.class)).map(CsvField::name).orElse("");
        String tableName = fileName.replace(".txt", "");
        String translationFieldName = csvFieldName.isEmpty() ? prefix + this.getObjectFieldNameAsCSVFieldName(field.getName(), fieldNameConvention) : csvFieldName;
        List<Translation> translationList = null;
        String string = key = recordSubId != null ? String.join((CharSequence)"_", recordId, recordSubId) : recordId;
        if (tableName.equals(TABLE_FEED_INFO)) {
            Map<String, List<Translation>> feeds = this.translationMap.get(tableName);
            if (feeds != null) {
                translationList = feeds.get("");
            }
        } else {
            Map<String, List<Translation>> translationsByValue;
            Map<String, List<Translation>> translationsByKey = this.translationMap.get(tableName + "_by_record");
            if (translationsByKey != null) {
                translationList = translationsByKey.get(key);
            }
            if (translationList == null && (translationsByValue = this.translationMap.get(tableName + "_by_field")) != null) {
                translationList = translationsByValue.get(defaultValue);
            }
        }
        if (translationList != null) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put(null, defaultValue);
            hm.put(this.feedLanguage, defaultValue);
            for (Translation translation : translationList) {
                if (!translationFieldName.equals(translation.getFieldName())) continue;
                hm.put(translation.getLanguage(), translation.getTranslation());
            }
            return TranslatedString.getI18NString(hm, true, false);
        }
        return NonLocalizedString.ofNullable(defaultValue);
    }

    private String getObjectFieldNameAsCSVFieldName(String fieldName, CsvFieldNameConvention fieldNameConvention) {
        if (fieldNameConvention == CsvFieldNameConvention.CAMEL_CASE) {
            return fieldName;
        }
        if (fieldNameConvention == CsvFieldNameConvention.CAPITALIZED_CAMEL_CASE) {
            return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        }
        StringBuilder b = new StringBuilder();
        boolean wasUpperCase = false;
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase) {
                c = Character.toLowerCase(c);
            }
            if (isUpperCase && !wasUpperCase) {
                b.append('_');
            }
            b.append(c);
            wasUpperCase = isUpperCase;
        }
        return b.toString();
    }
}

