/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.Location;
import org.onebusaway.gtfs.model.LocationGroup;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.framework.collection.MapUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.gtfs.mapping.BookingRuleMapper;
import org.opentripplanner.gtfs.mapping.LocationGroupMapper;
import org.opentripplanner.gtfs.mapping.LocationMapper;
import org.opentripplanner.gtfs.mapping.PickDropMapper;
import org.opentripplanner.gtfs.mapping.StopMapper;
import org.opentripplanner.gtfs.mapping.TranslationHelper;
import org.opentripplanner.gtfs.mapping.TripMapper;
import org.opentripplanner.model.StopTime;

class StopTimeMapper {
    private final StopMapper stopMapper;
    private final LocationMapper locationMapper;
    private final LocationGroupMapper locationGroupMapper;
    private final TripMapper tripMapper;
    private final BookingRuleMapper bookingRuleMapper;
    private final Map<org.onebusaway.gtfs.model.StopTime, StopTime> mappedStopTimes = new HashMap<org.onebusaway.gtfs.model.StopTime, StopTime>();
    private final TranslationHelper translationHelper;

    StopTimeMapper(StopMapper stopMapper, LocationMapper locationMapper, LocationGroupMapper locationGroupMapper, TripMapper tripMapper, BookingRuleMapper bookingRuleMapper, TranslationHelper translationHelper) {
        this.stopMapper = stopMapper;
        this.locationMapper = locationMapper;
        this.locationGroupMapper = locationGroupMapper;
        this.tripMapper = tripMapper;
        this.bookingRuleMapper = bookingRuleMapper;
        this.translationHelper = translationHelper;
    }

    Collection<StopTime> map(Collection<org.onebusaway.gtfs.model.StopTime> times) {
        return MapUtils.mapToList(times, this::map);
    }

    StopTime map(org.onebusaway.gtfs.model.StopTime orginal) {
        return orginal == null ? null : this.mappedStopTimes.computeIfAbsent(orginal, this::doMap);
    }

    private StopTime doMap(org.onebusaway.gtfs.model.StopTime rhs) {
        StopTime lhs = new StopTime();
        lhs.setTrip(this.tripMapper.map(rhs.getTrip()));
        if (rhs.getStop() instanceof Stop) {
            lhs.setStop(this.stopMapper.map((Stop)rhs.getStop()));
        } else if (rhs.getStop() instanceof Location) {
            lhs.setStop(this.locationMapper.map((Location)rhs.getStop()));
        } else if (rhs.getStop() instanceof LocationGroup) {
            lhs.setStop(this.locationGroupMapper.map((LocationGroup)rhs.getStop()));
        }
        I18NString stopHeadsign = null;
        if (rhs.getStopHeadsign() != null) {
            stopHeadsign = this.translationHelper.getTranslation(org.onebusaway.gtfs.model.StopTime.class, "stopHeadsign", rhs.getTrip().getId().toString(), Integer.toString(rhs.getStopSequence()), rhs.getStopHeadsign());
        }
        lhs.setArrivalTime(rhs.getArrivalTime());
        lhs.setDepartureTime(rhs.getDepartureTime());
        lhs.setTimepoint(rhs.getTimepoint());
        lhs.setStopSequence(rhs.getStopSequence());
        lhs.setStopHeadsign(stopHeadsign);
        lhs.setRouteShortName(rhs.getRouteShortName());
        lhs.setPickupType(PickDropMapper.map(rhs.getPickupType()));
        lhs.setDropOffType(PickDropMapper.map(rhs.getDropOffType()));
        lhs.setShapeDistTraveled(rhs.getShapeDistTraveled());
        lhs.setFarePeriodId(rhs.getFarePeriodId());
        lhs.setFlexWindowStart(rhs.getStartPickupDropOffWindow());
        lhs.setFlexWindowEnd(rhs.getEndPickupDropOffWindow());
        lhs.setFlexContinuousPickup(PickDropMapper.mapFlexContinuousPickDrop(rhs.getContinuousPickup()));
        lhs.setFlexContinuousDropOff(PickDropMapper.mapFlexContinuousPickDrop(rhs.getContinuousDropOff()));
        lhs.setPickupBookingInfo(this.bookingRuleMapper.map(rhs.getPickupBookingRule()));
        lhs.setDropOffBookingInfo(this.bookingRuleMapper.map(rhs.getDropOffBookingRule()));
        if (rhs.getProxy() != null) {
            throw new IllegalStateException("Did not expect proxy to be set!");
        }
        return lhs;
    }
}

