/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.ServiceCalendar;
import org.opentripplanner.framework.collection.MapUtils;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.ServiceDateMapper;

class ServiceCalendarMapper {
    private final Map<ServiceCalendar, org.opentripplanner.model.calendar.ServiceCalendar> mappedCalendars = new HashMap<ServiceCalendar, org.opentripplanner.model.calendar.ServiceCalendar>();

    ServiceCalendarMapper() {
    }

    Collection<org.opentripplanner.model.calendar.ServiceCalendar> map(Collection<ServiceCalendar> allServiceCalendars) {
        return MapUtils.mapToList(allServiceCalendars, this::map);
    }

    org.opentripplanner.model.calendar.ServiceCalendar map(ServiceCalendar orginal) {
        return orginal == null ? null : this.mappedCalendars.computeIfAbsent(orginal, this::doMap);
    }

    private org.opentripplanner.model.calendar.ServiceCalendar doMap(ServiceCalendar rhs) {
        org.opentripplanner.model.calendar.ServiceCalendar lhs = new org.opentripplanner.model.calendar.ServiceCalendar();
        lhs.setServiceId(AgencyAndIdMapper.mapAgencyAndId(rhs.getServiceId()));
        lhs.setMonday(rhs.getMonday());
        lhs.setTuesday(rhs.getTuesday());
        lhs.setWednesday(rhs.getWednesday());
        lhs.setThursday(rhs.getThursday());
        lhs.setFriday(rhs.getFriday());
        lhs.setSaturday(rhs.getSaturday());
        lhs.setSunday(rhs.getSunday());
        lhs.setPeriod(ServiceDateMapper.mapServiceDateInterval(rhs.getStartDate(), rhs.getEndDate()));
        return lhs;
    }
}

