/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.framework.collection.MapUtils;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.BoardingAreaMapper;
import org.opentripplanner.gtfs.mapping.EntranceMapper;
import org.opentripplanner.gtfs.mapping.PathwayModeMapper;
import org.opentripplanner.gtfs.mapping.PathwayNodeMapper;
import org.opentripplanner.gtfs.mapping.StopMapper;
import org.opentripplanner.transit.model.site.Pathway;
import org.opentripplanner.transit.model.site.PathwayBuilder;
import org.opentripplanner.transit.model.site.StationElement;

class PathwayMapper {
    private final StopMapper stopMapper;
    private final EntranceMapper entranceMapper;
    private final PathwayNodeMapper nodeMapper;
    private final BoardingAreaMapper boardingAreaMapper;
    private final Map<org.onebusaway.gtfs.model.Pathway, Pathway> mappedPathways = new HashMap<org.onebusaway.gtfs.model.Pathway, Pathway>();

    PathwayMapper(StopMapper stopMapper, EntranceMapper entranceMapper, PathwayNodeMapper nodeMapper, BoardingAreaMapper boardingAreaMapper) {
        this.stopMapper = stopMapper;
        this.entranceMapper = entranceMapper;
        this.nodeMapper = nodeMapper;
        this.boardingAreaMapper = boardingAreaMapper;
    }

    Collection<Pathway> map(Collection<org.onebusaway.gtfs.model.Pathway> allPathways) {
        return MapUtils.mapToList(allPathways, this::map);
    }

    Pathway map(org.onebusaway.gtfs.model.Pathway orginal) {
        return orginal == null ? null : this.mappedPathways.computeIfAbsent(orginal, this::doMap);
    }

    private Pathway doMap(org.onebusaway.gtfs.model.Pathway rhs) {
        PathwayBuilder pathway = Pathway.of(AgencyAndIdMapper.mapAgencyAndId(rhs.getId())).withPathwayMode(PathwayModeMapper.map(rhs.getPathwayMode())).withFromStop(this.mapStationElement(rhs.getFromStop())).withToStop(this.mapStationElement(rhs.getToStop())).withName(rhs.getSignpostedAs()).withReversedName(rhs.getReversedSignpostedAs()).withIsBidirectional(rhs.getIsBidirectional() == 1);
        if (rhs.isTraversalTimeSet()) {
            pathway.withTraversalTime(rhs.getTraversalTime());
        }
        if (rhs.isLengthSet()) {
            pathway.withLength(rhs.getLength());
        }
        if (rhs.isStairCountSet()) {
            pathway.withStairCount(rhs.getStairCount());
        }
        if (rhs.isMaxSlopeSet()) {
            pathway.withSlope(rhs.getMaxSlope());
        }
        return (Pathway)pathway.build();
    }

    private StationElement<?, ?> mapStationElement(Stop stop) {
        if (stop != null) {
            switch (stop.getLocationType()) {
                case 0: {
                    return this.stopMapper.map(stop);
                }
                case 2: {
                    return this.entranceMapper.map(stop);
                }
                case 3: {
                    return this.nodeMapper.map(stop);
                }
                case 4: {
                    return this.boardingAreaMapper.map(stop);
                }
            }
        }
        return null;
    }
}

