/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.Location;
import org.onebusaway.gtfs.model.LocationGroup;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.opentripplanner.framework.collection.MapUtils;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.LocationMapper;
import org.opentripplanner.gtfs.mapping.StopMapper;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.GroupStopBuilder;

public class LocationGroupMapper {
    private final StopMapper stopMapper;
    private final LocationMapper locationMapper;
    private final Map<LocationGroup, GroupStop> mappedLocationGroups = new HashMap<LocationGroup, GroupStop>();

    public LocationGroupMapper(StopMapper stopMapper, LocationMapper locationMapper) {
        this.stopMapper = stopMapper;
        this.locationMapper = locationMapper;
    }

    Collection<GroupStop> map(Collection<LocationGroup> allLocationGroups) {
        return MapUtils.mapToList(allLocationGroups, this::map);
    }

    GroupStop map(LocationGroup original) {
        return original == null ? null : this.mappedLocationGroups.computeIfAbsent(original, this::doMap);
    }

    private GroupStop doMap(LocationGroup element) {
        GroupStopBuilder groupStopBuilder = GroupStop.of(AgencyAndIdMapper.mapAgencyAndId(element.getId())).withName(new NonLocalizedString(element.getName()));
        for (StopLocation location : element.getLocations()) {
            if (location instanceof Stop) {
                groupStopBuilder.addLocation(this.stopMapper.map((Stop)location));
                continue;
            }
            if (location instanceof Location) {
                groupStopBuilder.addLocation(this.locationMapper.map((Location)location));
                continue;
            }
            if (location instanceof LocationGroup) {
                throw new RuntimeException("Nested GroupStops are not allowed");
            }
            throw new RuntimeException("Unknown location type: " + location.getClass().getSimpleName());
        }
        return (GroupStop)groupStopBuilder.build();
    }
}

