/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.function.Function;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.opentripplanner.ext.fares.model.FareRulesData;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.AgencyMapper;
import org.opentripplanner.gtfs.mapping.BoardingAreaMapper;
import org.opentripplanner.gtfs.mapping.BookingRuleMapper;
import org.opentripplanner.gtfs.mapping.DirectionMapper;
import org.opentripplanner.gtfs.mapping.EntranceMapper;
import org.opentripplanner.gtfs.mapping.FareAttributeMapper;
import org.opentripplanner.gtfs.mapping.FareLegRuleMapper;
import org.opentripplanner.gtfs.mapping.FareProductMapper;
import org.opentripplanner.gtfs.mapping.FareRuleMapper;
import org.opentripplanner.gtfs.mapping.FareTransferRuleMapper;
import org.opentripplanner.gtfs.mapping.FeedInfoMapper;
import org.opentripplanner.gtfs.mapping.FrequencyMapper;
import org.opentripplanner.gtfs.mapping.LocationGroupMapper;
import org.opentripplanner.gtfs.mapping.LocationMapper;
import org.opentripplanner.gtfs.mapping.PathwayMapper;
import org.opentripplanner.gtfs.mapping.PathwayNodeMapper;
import org.opentripplanner.gtfs.mapping.RouteMapper;
import org.opentripplanner.gtfs.mapping.ServiceCalendarDateMapper;
import org.opentripplanner.gtfs.mapping.ServiceCalendarMapper;
import org.opentripplanner.gtfs.mapping.ShapePointMapper;
import org.opentripplanner.gtfs.mapping.StationMapper;
import org.opentripplanner.gtfs.mapping.StopMapper;
import org.opentripplanner.gtfs.mapping.StopTimeMapper;
import org.opentripplanner.gtfs.mapping.TransferMapper;
import org.opentripplanner.gtfs.mapping.TransferMappingResult;
import org.opentripplanner.gtfs.mapping.TranslationHelper;
import org.opentripplanner.gtfs.mapping.TripMapper;
import org.opentripplanner.model.ShapePoint;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopTransferPriority;

public class GTFSToOtpTransitServiceMapper {
    private final AgencyMapper agencyMapper;
    private final StationMapper stationMapper;
    private final StopMapper stopMapper;
    private final EntranceMapper entranceMapper;
    private final PathwayNodeMapper pathwayNodeMapper;
    private final BoardingAreaMapper boardingAreaMapper;
    private final LocationMapper locationMapper = new LocationMapper();
    private final LocationGroupMapper locationGroupMapper;
    private final FareAttributeMapper fareAttributeMapper = new FareAttributeMapper();
    private final ServiceCalendarDateMapper serviceCalendarDateMapper = new ServiceCalendarDateMapper();
    private final FeedInfoMapper feedInfoMapper;
    private final ShapePointMapper shapePointMapper = new ShapePointMapper();
    private final ServiceCalendarMapper serviceCalendarMapper = new ServiceCalendarMapper();
    private final PathwayMapper pathwayMapper;
    private final RouteMapper routeMapper;
    private final TripMapper tripMapper;
    private final BookingRuleMapper bookingRuleMapper;
    private final StopTimeMapper stopTimeMapper;
    private final FrequencyMapper frequencyMapper;
    private final FareRuleMapper fareRuleMapper;
    private final FareProductMapper fareProductMapper;
    private final FareLegRuleMapper fareLegRuleMapper;
    private final FareTransferRuleMapper fareTransferRuleMapper;
    private final DirectionMapper directionMapper;
    private final DataImportIssueStore issueStore;
    private final GtfsRelationalDao data;
    private final OtpTransitServiceBuilder builder;
    private final FareRulesData fareRulesBuilder = new FareRulesData();
    private final TranslationHelper translationHelper;
    private final boolean discardMinTransferTimes;

    public GTFSToOtpTransitServiceMapper(String feedId, DataImportIssueStore issueStore, boolean discardMinTransferTimes, GtfsRelationalDao data, StopTransferPriority stationTransferPreference) {
        this.issueStore = issueStore;
        this.builder = new OtpTransitServiceBuilder(this.issueStore);
        Function<FeedScopedId, Station> stationLookup = id -> this.builder.getStations().get((FeedScopedId)id);
        Function<FeedScopedId, RegularStop> stopLookup = id -> this.builder.getStops().get((FeedScopedId)id);
        this.data = data;
        this.discardMinTransferTimes = discardMinTransferTimes;
        this.translationHelper = new TranslationHelper();
        this.feedInfoMapper = new FeedInfoMapper(feedId);
        this.agencyMapper = new AgencyMapper(feedId);
        this.stationMapper = new StationMapper(this.translationHelper, stationTransferPreference);
        this.stopMapper = new StopMapper(this.translationHelper, stationLookup);
        this.entranceMapper = new EntranceMapper(this.translationHelper, stationLookup);
        this.pathwayNodeMapper = new PathwayNodeMapper(this.translationHelper, stationLookup);
        this.boardingAreaMapper = new BoardingAreaMapper(this.translationHelper, stopLookup);
        this.locationGroupMapper = new LocationGroupMapper(this.stopMapper, this.locationMapper);
        this.pathwayMapper = new PathwayMapper(this.stopMapper, this.entranceMapper, this.pathwayNodeMapper, this.boardingAreaMapper);
        this.routeMapper = new RouteMapper(this.agencyMapper, issueStore, this.translationHelper);
        this.directionMapper = new DirectionMapper(issueStore);
        this.tripMapper = new TripMapper(this.routeMapper, this.directionMapper, this.translationHelper);
        this.bookingRuleMapper = new BookingRuleMapper();
        this.stopTimeMapper = new StopTimeMapper(this.stopMapper, this.locationMapper, this.locationGroupMapper, this.tripMapper, this.bookingRuleMapper, this.translationHelper);
        this.frequencyMapper = new FrequencyMapper(this.tripMapper);
        this.fareRuleMapper = new FareRuleMapper(this.routeMapper, this.fareAttributeMapper);
        this.fareProductMapper = new FareProductMapper();
        this.fareLegRuleMapper = new FareLegRuleMapper(this.fareProductMapper, issueStore);
        this.fareTransferRuleMapper = new FareTransferRuleMapper(this.fareProductMapper, issueStore);
    }

    public OtpTransitServiceBuilder getBuilder() {
        return this.builder;
    }

    public FareRulesData getFareRulesService() {
        return this.fareRulesBuilder;
    }

    public void mapStopTripAndRouteDataIntoBuilder() {
        this.translationHelper.importTranslations(this.data.getAllTranslations(), this.data.getAllFeedInfos());
        this.builder.getAgenciesById().addAll(this.agencyMapper.map(this.data.getAllAgencies()));
        this.builder.getCalendarDates().addAll(this.serviceCalendarDateMapper.map(this.data.getAllCalendarDates()));
        this.builder.getCalendars().addAll(this.serviceCalendarMapper.map(this.data.getAllCalendars()));
        this.builder.getFeedInfos().addAll(this.feedInfoMapper.map(this.data.getAllFeedInfos()));
        this.builder.getFrequencies().addAll(this.frequencyMapper.map(this.data.getAllFrequencies()));
        this.builder.getRoutes().addAll(this.routeMapper.map(this.data.getAllRoutes()));
        for (ShapePoint shapePoint : this.shapePointMapper.map(this.data.getAllShapePoints())) {
            this.builder.getShapePoints().put((Object)shapePoint.getShapeId(), (Object)shapePoint);
        }
        this.mapGtfsStopsToOtpTypes(this.data.getAllStops());
        if (OTPFeature.FlexRouting.isOn()) {
            this.builder.getAreaStops().addAll(this.locationMapper.map(this.data.getAllLocations()));
            this.builder.getGroupStops().addAll(this.locationGroupMapper.map(this.data.getAllLocationGroups()));
        }
        this.builder.getPathways().addAll(this.pathwayMapper.map(this.data.getAllPathways()));
        this.builder.getStopTimesSortedByTrip().addAll(this.stopTimeMapper.map(this.data.getAllStopTimes()));
        this.builder.getTripsById().addAll(this.tripMapper.map(this.data.getAllTrips()));
        this.fareRulesBuilder.fareAttributes().addAll(this.fareAttributeMapper.map(this.data.getAllFareAttributes()));
        this.fareRulesBuilder.fareRules().addAll(this.fareRuleMapper.map(this.data.getAllFareRules()));
        this.fareProductMapper.map(this.data.getAllFareProducts());
        this.fareRulesBuilder.fareLegRules().addAll(this.fareLegRuleMapper.map(this.data.getAllFareLegRules()));
        this.fareRulesBuilder.fareTransferRules().addAll(this.fareTransferRuleMapper.map(this.data.getAllFareTransferRules()));
    }

    private void mapGtfsStopsToOtpTypes(Collection<Stop> stops) {
        for (Stop it : stops) {
            if (it.getLocationType() != 1) continue;
            this.builder.getStations().add(this.stationMapper.map(it));
        }
        for (Stop it : stops) {
            if (it.getLocationType() == 0) {
                this.builder.getStops().add(this.stopMapper.map(it));
                continue;
            }
            if (it.getLocationType() == 2) {
                this.builder.getEntrances().add(this.entranceMapper.map(it));
                continue;
            }
            if (it.getLocationType() != 3) continue;
            this.builder.getPathwayNodes().add(this.pathwayNodeMapper.map(it));
        }
        for (Stop it : stops) {
            if (it.getLocationType() != 4) continue;
            this.builder.getBoardingAreas().add(this.boardingAreaMapper.map(it));
        }
    }

    public void mapAndAddTransfersToBuilder() {
        TransferMapper transferMapper = new TransferMapper(this.routeMapper, this.stationMapper, this.stopMapper, this.tripMapper, this.builder.getStopTimesSortedByTrip(), this.discardMinTransferTimes, this.issueStore);
        TransferMappingResult result = transferMapper.map(this.data.getAllTransfers());
        this.builder.getTransfers().addAll(result.constrainedTransfers());
        this.builder.getStaySeatedNotAllowed().addAll(result.staySeatedNotAllowed());
    }
}

