/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import com.google.common.collect.Iterables;
import gnu.trove.list.TLongList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.logging.ProgressTracker;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.Graphwide;
import org.opentripplanner.graph_builder.issues.StreetCarSpeedZero;
import org.opentripplanner.graph_builder.issues.TurnRestrictionBad;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.osm.Area;
import org.opentripplanner.graph_builder.module.osm.AreaGroup;
import org.opentripplanner.graph_builder.module.osm.ElevatorProcessor;
import org.opentripplanner.graph_builder.module.osm.OSMDatabase;
import org.opentripplanner.graph_builder.module.osm.OSMFilter;
import org.opentripplanner.graph_builder.module.osm.ParkingProcessor;
import org.opentripplanner.graph_builder.module.osm.Ring;
import org.opentripplanner.graph_builder.module.osm.StreetTraversalPermissionPair;
import org.opentripplanner.graph_builder.module.osm.TurnRestrictionTag;
import org.opentripplanner.graph_builder.module.osm.WalkableAreaBuilder;
import org.opentripplanner.graph_builder.services.osm.CustomNamer;
import org.opentripplanner.openstreetmap.OpenStreetMapProvider;
import org.opentripplanner.openstreetmap.model.OSMLevel;
import org.opentripplanner.openstreetmap.model.OSMNode;
import org.opentripplanner.openstreetmap.model.OSMWay;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.openstreetmap.tagmapping.OsmTagMapper;
import org.opentripplanner.openstreetmap.wayproperty.WayProperties;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.util.ElevationUtils;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.TurnRestriction;
import org.opentripplanner.street.model.edge.AreaEdge;
import org.opentripplanner.street.model.edge.AreaEdgeList;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.NamedArea;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.note.StreetNoteAndMatcher;
import org.opentripplanner.street.model.vertex.BarrierVertex;
import org.opentripplanner.street.model.vertex.ExitVertex;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.OsmBoardingLocationVertex;
import org.opentripplanner.street.model.vertex.OsmVertex;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenStreetMapModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(OpenStreetMapModule.class);
    private final Map<Vertex, Double> elevationData = new HashMap<Vertex, Double>();
    private final List<OpenStreetMapProvider> providers;
    private final Set<String> boardingAreaRefTags;
    private final DataImportIssueStore issueStore;
    private final Graph graph;
    private final boolean areaVisibility;
    public boolean platformEntriesLinking = false;
    public CustomNamer customNamer;
    public boolean staticParkAndRide = true;
    public boolean staticBikeParkAndRide;
    public int maxAreaNodes = 500;
    public boolean banDiscouragedWalking = false;
    public boolean banDiscouragedBiking = false;

    public OpenStreetMapModule(Collection<OpenStreetMapProvider> providers, Set<String> boardingAreaRefTags, Graph graph, DataImportIssueStore issueStore, boolean areaVisibility) {
        this.providers = List.copyOf(providers);
        this.boardingAreaRefTags = boardingAreaRefTags;
        this.graph = graph;
        this.issueStore = issueStore;
        this.areaVisibility = areaVisibility;
    }

    public OpenStreetMapModule(BuildConfig config, Collection<OpenStreetMapProvider> providers, Set<String> boardingAreaRefTags, Graph graph, DataImportIssueStore issueStore) {
        this(List.copyOf(providers), boardingAreaRefTags, graph, issueStore, config.areaVisibility);
        this.customNamer = config.customNamer;
        this.platformEntriesLinking = config.platformEntriesLinking;
        this.staticBikeParkAndRide = config.staticBikeParkAndRide;
        this.staticParkAndRide = config.staticParkAndRide;
        this.banDiscouragedWalking = config.banDiscouragedWalking;
        this.banDiscouragedBiking = config.banDiscouragedBiking;
        this.maxAreaNodes = config.maxAreaNodes;
    }

    @Override
    public void buildGraph() {
        OSMDatabase osmdb = new OSMDatabase(this.issueStore, this.boardingAreaRefTags);
        Handler handler = new Handler(this.graph, osmdb);
        for (OpenStreetMapProvider provider : this.providers) {
            LOG.info("Gathering OSM from provider: {}", (Object)provider);
            LOG.info("Using OSM way configuration from {}.", (Object)provider.getOsmTagMapper().getClass().getSimpleName());
            provider.readOSM(osmdb);
        }
        osmdb.postLoad();
        LOG.info("Building street graph from OSM");
        handler.buildGraph();
        this.graph.hasStreets = true;
    }

    @Override
    public void checkInputs() {
        for (OpenStreetMapProvider provider : this.providers) {
            provider.checkInputs();
        }
    }

    public Map<Vertex, Double> elevationDataOutput() {
        return this.elevationData;
    }

    protected class Handler {
        private static final String nodeLabelFormat = "osm:node:%d";
        private static final String levelnodeLabelFormat = "osm:node:%d:level:%s";
        private final Graph graph;
        private final OSMDatabase osmdb;
        private final HashMap<Long, Map<OSMLevel, OsmVertex>> multiLevelNodes = new HashMap();
        private final Map<Long, IntersectionVertex> intersectionNodes = new HashMap<Long, IntersectionVertex>();
        private float bestBikeSafety = 1.0f;
        private float bestWalkSafety = 1.0f;

        public Handler(Graph graph, OSMDatabase osmdb) {
            this.graph = graph;
            this.osmdb = osmdb;
        }

        public void buildGraph() {
            List<AreaGroup> areaGroups;
            ParkingProcessor parkingProcessor = new ParkingProcessor(this.graph, OpenStreetMapModule.this.issueStore, this::getVertexForOsmNode);
            ArrayList<VehicleParking> parkingLots = new ArrayList<VehicleParking>();
            if (OpenStreetMapModule.this.staticParkAndRide) {
                List<VehicleParking> carParkingNodes = parkingProcessor.buildParkAndRideNodes(this.osmdb.getCarParkingNodes(), true);
                parkingLots.addAll(carParkingNodes);
            }
            if (OpenStreetMapModule.this.staticBikeParkAndRide) {
                List<VehicleParking> bikeParkingNodes = parkingProcessor.buildParkAndRideNodes(this.osmdb.getBikeParkingNodes(), false);
                parkingLots.addAll(bikeParkingNodes);
            }
            for (Area area : Iterables.concat(this.osmdb.getWalkableAreas(), this.osmdb.getParkAndRideAreas(), this.osmdb.getBikeParkingAreas())) {
                this.setWayName(area.parent);
            }
            this.initIntersectionNodes();
            this.buildBasicGraph();
            this.buildWalkableAreas(!OpenStreetMapModule.this.areaVisibility, OpenStreetMapModule.this.platformEntriesLinking);
            if (OpenStreetMapModule.this.staticParkAndRide) {
                areaGroups = this.groupAreas(this.osmdb.getParkAndRideAreas());
                Collection<VehicleParking> carParkingAreas = parkingProcessor.buildParkAndRideAreas(areaGroups);
                parkingLots.addAll(carParkingAreas);
                LOG.info("Created {} car P+R areas.", (Object)carParkingAreas.size());
            }
            if (OpenStreetMapModule.this.staticBikeParkAndRide) {
                areaGroups = this.groupAreas(this.osmdb.getBikeParkingAreas());
                Collection<VehicleParking> bikeParkingAreas = parkingProcessor.buildBikeParkAndRideAreas(areaGroups);
                parkingLots.addAll(bikeParkingAreas);
                LOG.info("Created {} bike P+R areas", (Object)bikeParkingAreas.size());
            }
            if (!parkingLots.isEmpty()) {
                this.graph.getVehicleParkingService().updateVehicleParking(parkingLots, List.of());
            }
            ElevatorProcessor elevatorProcessor = new ElevatorProcessor(OpenStreetMapModule.this.issueStore, this.osmdb, this.multiLevelNodes, this.intersectionNodes);
            elevatorProcessor.buildElevatorEdges(this.graph);
            this.unifyTurnRestrictions();
            if (OpenStreetMapModule.this.customNamer != null) {
                OpenStreetMapModule.this.customNamer.postprocess(this.graph);
            }
            this.applySafetyFactors(this.graph);
        }

        protected void applyWayProperties(StreetEdge street, StreetEdge backStreet, WayProperties wayData, OSMWithTags way) {
            double walkSafety;
            double bicycleSafety;
            OsmTagMapper tagMapperForWay = way.getOsmProvider().getOsmTagMapper();
            Set<StreetNoteAndMatcher> notes = way.getOsmProvider().getWayPropertySet().getNoteForWay(way);
            boolean motorVehicleNoThrough = tagMapperForWay.isMotorVehicleThroughTrafficExplicitlyDisallowed(way);
            boolean bicycleNoThrough = tagMapperForWay.isBicycleNoThroughTrafficExplicitlyDisallowed(way);
            boolean walkNoThrough = tagMapperForWay.isWalkNoThroughTrafficExplicitlyDisallowed(way);
            if (street != null) {
                bicycleSafety = wayData.getBicycleSafetyFeatures().forward();
                street.setBicycleSafetyFactor((float)bicycleSafety);
                if (bicycleSafety < (double)this.bestBikeSafety) {
                    this.bestBikeSafety = (float)bicycleSafety;
                }
                walkSafety = wayData.getWalkSafetyFeatures().forward();
                street.setWalkSafetyFactor((float)walkSafety);
                if (walkSafety < (double)this.bestWalkSafety) {
                    this.bestWalkSafety = (float)walkSafety;
                }
                if (notes != null) {
                    for (StreetNoteAndMatcher it : notes) {
                        this.graph.streetNotesService.addStaticNote(street, it.note(), it.matcher());
                    }
                }
                street.setMotorVehicleNoThruTraffic(motorVehicleNoThrough);
                street.setBicycleNoThruTraffic(bicycleNoThrough);
                street.setWalkNoThruTraffic(walkNoThrough);
            }
            if (backStreet != null) {
                bicycleSafety = wayData.getBicycleSafetyFeatures().back();
                if (bicycleSafety < (double)this.bestBikeSafety) {
                    this.bestBikeSafety = (float)bicycleSafety;
                }
                backStreet.setBicycleSafetyFactor((float)bicycleSafety);
                walkSafety = wayData.getWalkSafetyFeatures().back();
                if (walkSafety < (double)this.bestWalkSafety) {
                    this.bestWalkSafety = (float)walkSafety;
                }
                backStreet.setWalkSafetyFactor((float)walkSafety);
                if (notes != null) {
                    for (StreetNoteAndMatcher it : notes) {
                        this.graph.streetNotesService.addStaticNote(backStreet, it.note(), it.matcher());
                    }
                }
                backStreet.setMotorVehicleNoThruTraffic(motorVehicleNoThrough);
                backStreet.setBicycleNoThruTraffic(bicycleNoThrough);
                backStreet.setWalkNoThruTraffic(walkNoThrough);
            }
        }

        protected I18NString getNameForWay(OSMWithTags way, String id) {
            I18NString name = way.getAssumedName();
            if (OpenStreetMapModule.this.customNamer != null && name != null) {
                name = new NonLocalizedString(OpenStreetMapModule.this.customNamer.name(way, name.toString()));
            }
            if (name == null) {
                name = new NonLocalizedString(id);
            }
            return name;
        }

        protected IntersectionVertex getVertexForOsmNode(OSMNode node, OSMWithTags way) {
            IntersectionVertex iv = null;
            if (node.isMultiLevel()) {
                return this.recordLevel(node, way);
            }
            long nid = node.getId();
            iv = this.intersectionNodes.get(nid);
            if (iv == null) {
                Set<String> refs;
                String ref;
                Coordinate coordinate = this.getCoordinate(node);
                String label = String.format(nodeLabelFormat, node.getId());
                String highway = node.getTag("highway");
                if ("motorway_junction".equals(highway) && (ref = node.getTag("ref")) != null) {
                    ExitVertex ev = new ExitVertex(this.graph, label, coordinate.x, coordinate.y, nid);
                    ev.setExitName(ref);
                    iv = ev;
                }
                if (node.isBoardingLocation() && !(refs = node.getMultiTagValues(OpenStreetMapModule.this.boardingAreaRefTags)).isEmpty()) {
                    String name = node.getTag("name");
                    iv = new OsmBoardingLocationVertex(this.graph, label, coordinate.x, coordinate.y, NonLocalizedString.ofNullable(name), refs);
                }
                if (node.isBarrier()) {
                    BarrierVertex bv = new BarrierVertex(this.graph, label, coordinate.x, coordinate.y, nid);
                    bv.setBarrierPermissions(OSMFilter.getPermissionsForEntity(node, BarrierVertex.defaultBarrierPermissions));
                    iv = bv;
                }
                if (iv == null) {
                    iv = new OsmVertex(this.graph, label, coordinate.x, coordinate.y, node.getId(), new NonLocalizedString(label), node.hasHighwayTrafficLight(), node.hasCrossingTrafficLight());
                }
                this.intersectionNodes.put(nid, iv);
            }
            return iv;
        }

        private static double getGeometryLengthMeters(Geometry geometry) {
            Coordinate[] coordinates = geometry.getCoordinates();
            double d = 0.0;
            for (int i = 1; i < coordinates.length; ++i) {
                d += SphericalDistanceLibrary.distance(coordinates[i - 1], coordinates[i]);
            }
            return d;
        }

        private List<AreaGroup> groupAreas(Collection<Area> areas) {
            HashMap<Area, OSMLevel> areasLevels = new HashMap<Area, OSMLevel>(areas.size());
            for (Area area : areas) {
                areasLevels.put(area, this.osmdb.getLevelForWay(area.parent));
            }
            return AreaGroup.groupAreas(areasLevels);
        }

        private void buildWalkableAreas(boolean skipVisibility, boolean platformEntriesLinking) {
            if (skipVisibility) {
                LOG.info("Skipping visibility graph construction for walkable areas and using just area rings for edges.");
            } else {
                LOG.info("Building visibility graphs for walkable areas.");
            }
            List<AreaGroup> areaGroups = this.groupAreas(this.osmdb.getWalkableAreas());
            WalkableAreaBuilder walkableAreaBuilder = new WalkableAreaBuilder(this.graph, this.osmdb, this, OpenStreetMapModule.this.issueStore, OpenStreetMapModule.this.maxAreaNodes, platformEntriesLinking, OpenStreetMapModule.this.boardingAreaRefTags);
            if (skipVisibility) {
                for (AreaGroup group : areaGroups) {
                    walkableAreaBuilder.buildWithoutVisibility(group);
                }
            } else {
                ProgressTracker progress = ProgressTracker.track("Build visibility graph for areas", 50, areaGroups.size());
                for (AreaGroup group : areaGroups) {
                    walkableAreaBuilder.buildWithVisibility(group);
                    progress.step(m -> LOG.info(m));
                }
                LOG.info(progress.completeMessage());
            }
            if (skipVisibility) {
                LOG.info("Done building rings for walkable areas.");
            } else {
                LOG.info("Done building visibility graphs for walkable areas.");
            }
        }

        private void buildBasicGraph() {
            long wayCount = this.osmdb.getWays().size();
            ProgressTracker progress = ProgressTracker.track("Build street graph", 5000, wayCount);
            LOG.info(progress.startMessage());
            block0: for (OSMWay way : this.osmdb.getWays()) {
                WayProperties wayData = way.getOsmProvider().getWayPropertySet().getDataForWay(way);
                this.setWayName(way);
                StreetTraversalPermission permissions = OSMFilter.getPermissionsForWay(way, wayData.getPermission(), OpenStreetMapModule.this.banDiscouragedWalking, OpenStreetMapModule.this.banDiscouragedBiking, OpenStreetMapModule.this.issueStore);
                if (!OSMFilter.isWayRoutable(way) || permissions.allowsNothing()) continue;
                ArrayList<Long> nodes = new ArrayList<Long>(way.getNodeRefs().size());
                long last = -1L;
                double lastLat = -1.0;
                double lastLon = -1.0;
                String lastLevel = null;
                for (long nodeId : way.getNodeRefs()) {
                    OSMNode node = this.osmdb.getNode(nodeId);
                    if (node == null) continue block0;
                    boolean levelsDiffer = false;
                    String level = node.getTag("level");
                    if (lastLevel == null) {
                        if (level != null) {
                            levelsDiffer = true;
                        }
                    } else if (!lastLevel.equals(level)) {
                        levelsDiffer = true;
                    }
                    if (nodeId != last && (node.lat != lastLat || node.lon != lastLon || levelsDiffer)) {
                        nodes.add(nodeId);
                    }
                    last = nodeId;
                    lastLon = node.lon;
                    lastLat = node.lat;
                    lastLevel = level;
                }
                IntersectionVertex startEndpoint = null;
                IntersectionVertex endEndpoint = null;
                ArrayList<Coordinate> segmentCoordinates = new ArrayList<Coordinate>();
                Long startNode = null;
                OSMNode osmStartNode = null;
                for (int i = 0; i < nodes.size() - 1; ++i) {
                    Double elevation;
                    String ele;
                    OSMNode segmentStartOSMNode = this.osmdb.getNode((Long)nodes.get(i));
                    if (segmentStartOSMNode == null) continue;
                    Long endNode = (Long)nodes.get(i + 1);
                    if (osmStartNode == null) {
                        startNode = (Long)nodes.get(i);
                        osmStartNode = segmentStartOSMNode;
                    }
                    OSMNode osmEndNode = this.osmdb.getNode(endNode);
                    if (segmentCoordinates.size() == 0) {
                        segmentCoordinates.add(this.getCoordinate(osmStartNode));
                    }
                    if (!(this.intersectionNodes.containsKey(endNode) || i == nodes.size() - 2 || nodes.subList(0, i).contains(nodes.get(i)) || osmEndNode.hasTag("ele") || osmEndNode.isBoardingLocation() || osmEndNode.isBarrier())) {
                        segmentCoordinates.add(this.getCoordinate(osmEndNode));
                        continue;
                    }
                    segmentCoordinates.add(this.getCoordinate(osmEndNode));
                    LineString geometry = GeometryUtils.getGeometryFactory().createLineString(segmentCoordinates.toArray(new Coordinate[0]));
                    segmentCoordinates.clear();
                    if (startEndpoint == null) {
                        startEndpoint = this.getVertexForOsmNode(osmStartNode, way);
                        ele = segmentStartOSMNode.getTag("ele");
                        if (ele != null && (elevation = ElevationUtils.parseEleTag(ele)) != null) {
                            OpenStreetMapModule.this.elevationData.put(startEndpoint, elevation);
                        }
                    } else {
                        startEndpoint = endEndpoint;
                    }
                    endEndpoint = this.getVertexForOsmNode(osmEndNode, way);
                    ele = osmEndNode.getTag("ele");
                    if (ele != null && (elevation = ElevationUtils.parseEleTag(ele)) != null) {
                        OpenStreetMapModule.this.elevationData.put(endEndpoint, elevation);
                    }
                    StreetEdgePair streets = this.getEdgesForStreet(startEndpoint, endEndpoint, way, i, permissions, geometry);
                    StreetEdge street = streets.main;
                    StreetEdge backStreet = streets.back;
                    this.applyWayProperties(street, backStreet, wayData, way);
                    this.applyEdgesToTurnRestrictions(way, startNode, endNode, street, backStreet);
                    startNode = endNode;
                    osmStartNode = this.osmdb.getNode(startNode);
                }
                progress.step(m -> LOG.info(m));
            }
            LOG.info(progress.completeMessage());
        }

        private void setWayName(OSMWithTags way) {
            I18NString creativeName;
            if (!way.hasTag("name") && (creativeName = way.getOsmProvider().getWayPropertySet().getCreativeNameForWay(way)) != null) {
                way.setCreativeName(creativeName);
            }
        }

        private void unifyTurnRestrictions() {
            for (Long fromWay : this.osmdb.getTurnRestrictionWayIds()) {
                for (TurnRestrictionTag restrictionTag : this.osmdb.getFromWayTurnRestrictions(fromWay)) {
                    if (restrictionTag.possibleFrom.isEmpty()) {
                        OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "No from edge found"));
                        continue;
                    }
                    if (restrictionTag.possibleTo.isEmpty()) {
                        OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "No to edge found"));
                        continue;
                    }
                    for (StreetEdge from : restrictionTag.possibleFrom) {
                        if (from == null) {
                            OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "from-edge is null"));
                            continue;
                        }
                        block9: for (StreetEdge to : restrictionTag.possibleTo) {
                            if (to == null) {
                                OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "to-edge is null"));
                                continue;
                            }
                            int angleDiff = from.getOutAngle() - to.getInAngle();
                            if (angleDiff < 0) {
                                angleDiff += 360;
                            }
                            switch (restrictionTag.direction) {
                                case LEFT: {
                                    if (angleDiff < 160) break;
                                    OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "Left turn restriction is not on edges which turn left"));
                                    continue block9;
                                }
                                case RIGHT: {
                                    if (angleDiff > 200) break;
                                    OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "Right turn restriction is not on edges which turn right"));
                                    continue block9;
                                }
                                case U: {
                                    if (angleDiff > 150 && angleDiff <= 210) break;
                                    OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "U-turn restriction is not on U-turn"));
                                    continue block9;
                                }
                                case STRAIGHT: {
                                    if (angleDiff < 30 || angleDiff >= 330) break;
                                    OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "Straight turn restriction is not on edges which go straight"));
                                    continue block9;
                                }
                            }
                            TurnRestriction restriction = new TurnRestriction(from, to, restrictionTag.type, restrictionTag.modes, restrictionTag.time);
                            from.addTurnRestriction(restriction);
                        }
                    }
                }
            }
        }

        private void applyEdgesToTurnRestrictions(OSMWay way, long startNode, long endNode, StreetEdge street, StreetEdge backStreet) {
            Collection<TurnRestrictionTag> restrictionTags = this.osmdb.getFromWayTurnRestrictions(way.getId());
            if (restrictionTags != null) {
                for (TurnRestrictionTag tag : restrictionTags) {
                    if (tag.via == startNode) {
                        tag.possibleFrom.add(backStreet);
                        continue;
                    }
                    if (tag.via != endNode) continue;
                    tag.possibleFrom.add(street);
                }
            }
            if ((restrictionTags = this.osmdb.getToWayTurnRestrictions(way.getId())) != null) {
                for (TurnRestrictionTag tag : restrictionTags) {
                    if (tag.via == startNode) {
                        tag.possibleTo.add(street);
                        continue;
                    }
                    if (tag.via != endNode) continue;
                    tag.possibleTo.add(backStreet);
                }
            }
        }

        private void initIntersectionNodes() {
            HashSet<Long> possibleIntersectionNodes = new HashSet<Long>();
            for (OSMWay way : this.osmdb.getWays()) {
                TLongList nodes = way.getNodeRefs();
                nodes.forEach(node -> {
                    if (possibleIntersectionNodes.contains(node)) {
                        this.intersectionNodes.put(node, null);
                    } else {
                        possibleIntersectionNodes.add(node);
                    }
                    return true;
                });
            }
            for (Area area : Iterables.concat(this.osmdb.getWalkableAreas(), this.osmdb.getParkAndRideAreas(), this.osmdb.getBikeParkingAreas())) {
                for (Ring outerRing : area.outermostRings) {
                    this.intersectAreaRingNodes(possibleIntersectionNodes, outerRing);
                }
            }
        }

        private void intersectAreaRingNodes(Set<Long> possibleIntersectionNodes, Ring outerRing) {
            for (OSMNode node : outerRing.nodes) {
                long nodeId = node.getId();
                if (possibleIntersectionNodes.contains(nodeId)) {
                    this.intersectionNodes.put(nodeId, null);
                    continue;
                }
                possibleIntersectionNodes.add(nodeId);
            }
            outerRing.getHoles().forEach(hole -> this.intersectAreaRingNodes(possibleIntersectionNodes, (Ring)hole));
        }

        private void applySafetyFactors(Graph graph) {
            OpenStreetMapModule.this.issueStore.add(new Graphwide("Multiplying all bike safety values by " + 1.0f / this.bestBikeSafety));
            OpenStreetMapModule.this.issueStore.add(new Graphwide("Multiplying all walk safety values by " + 1.0f / this.bestWalkSafety));
            HashSet<Edge> seenEdges = new HashSet<Edge>();
            HashSet<AreaEdgeList> seenAreas = new HashSet<AreaEdgeList>();
            for (Vertex vertex : graph.getVertices()) {
                StreetEdge pse;
                for (Edge e : vertex.getOutgoing()) {
                    if (e instanceof AreaEdge) {
                        AreaEdgeList areaEdgeList = ((AreaEdge)e).getArea();
                        if (seenAreas.contains(areaEdgeList)) continue;
                        seenAreas.add(areaEdgeList);
                        for (NamedArea area : areaEdgeList.getAreas()) {
                            area.setBicycleSafetyMultiplier(area.getBicycleSafetyMultiplier() / (double)this.bestBikeSafety);
                            area.setWalkSafetyMultiplier(area.getWalkSafetyMultiplier() / (double)this.bestWalkSafety);
                        }
                    }
                    if (!(e instanceof StreetEdge)) continue;
                    pse = (StreetEdge)e;
                    if (seenEdges.contains(e)) continue;
                    seenEdges.add(e);
                    pse.setBicycleSafetyFactor(pse.getBicycleSafetyFactor() / this.bestBikeSafety);
                    pse.setWalkSafetyFactor(pse.getWalkSafetyFactor() / this.bestWalkSafety);
                }
                for (Edge e : vertex.getIncoming()) {
                    if (!(e instanceof StreetEdge)) continue;
                    pse = (StreetEdge)e;
                    if (seenEdges.contains(e)) continue;
                    seenEdges.add(e);
                    pse.setBicycleSafetyFactor(pse.getBicycleSafetyFactor() / this.bestBikeSafety);
                    pse.setWalkSafetyFactor(pse.getWalkSafetyFactor() / this.bestWalkSafety);
                }
            }
        }

        private Coordinate getCoordinate(OSMNode osmNode) {
            return new Coordinate(osmNode.lon, osmNode.lat);
        }

        private StreetEdgePair getEdgesForStreet(IntersectionVertex startEndpoint, IntersectionVertex endEndpoint, OSMWay way, int index, StreetTraversalPermission permissions, LineString geometry) {
            if (permissions.allowsNothing()) {
                return new StreetEdgePair(null, null);
            }
            LineString backGeometry = geometry.reverse();
            StreetEdge street = null;
            StreetEdge backStreet = null;
            double length = Handler.getGeometryLengthMeters((Geometry)geometry);
            StreetTraversalPermissionPair permissionPair = OSMFilter.getPermissions(permissions, way);
            StreetTraversalPermission permissionsFront = permissionPair.main();
            StreetTraversalPermission permissionsBack = permissionPair.back();
            if (permissionsFront.allowsAnything()) {
                street = this.getEdgeForStreet(startEndpoint, endEndpoint, way, index, length, permissionsFront, geometry, false);
            }
            if (permissionsBack.allowsAnything()) {
                backStreet = this.getEdgeForStreet(endEndpoint, startEndpoint, way, index, length, permissionsBack, backGeometry, true);
            }
            if (street != null && backStreet != null) {
                backStreet.shareData(street);
            }
            if (way.isRoundabout()) {
                if (street != null) {
                    street.setRoundabout(true);
                }
                if (backStreet != null) {
                    backStreet.setRoundabout(true);
                }
            }
            return new StreetEdgePair(street, backStreet);
        }

        private StreetEdge getEdgeForStreet(IntersectionVertex startEndpoint, IntersectionVertex endEndpoint, OSMWay way, int index, double length, StreetTraversalPermission permissions, LineString geometry, boolean back) {
            Object label = "way " + way.getId() + " from " + index;
            label = ((String)label).intern();
            I18NString name = this.getNameForWay(way, (String)label);
            float carSpeed = way.getOsmProvider().getWayPropertySet().getCarSpeedForWay(way, back);
            StreetEdge street = new StreetEdge((StreetVertex)startEndpoint, (StreetVertex)endEndpoint, geometry, name, length, permissions, back);
            street.setCarSpeed(carSpeed);
            street.setLink(OSMFilter.isLink(way));
            if (!way.hasTag("name") && !way.hasTag("ref")) {
                street.setHasBogusName(true);
            }
            boolean steps = way.isSteps();
            street.setStairs(steps);
            if (way.isTagFalse("wheelchair") || steps && !way.isTagTrue("wheelchair")) {
                street.setWheelchairAccessible(false);
            }
            street.setSlopeOverride(way.getOsmProvider().getWayPropertySet().getSlopeOverride(way));
            if ((double)carSpeed < 0.04) {
                OpenStreetMapModule.this.issueStore.add(new StreetCarSpeedZero(way));
            }
            if (OpenStreetMapModule.this.customNamer != null) {
                OpenStreetMapModule.this.customNamer.nameWithEdge(way, street);
            }
            return street;
        }

        private OsmVertex recordLevel(OSMNode node, OSMWithTags way) {
            Map<Object, Object> vertices;
            OSMLevel level = this.osmdb.getLevelForWay(way);
            long nodeId = node.getId();
            if (this.multiLevelNodes.containsKey(nodeId)) {
                vertices = this.multiLevelNodes.get(nodeId);
            } else {
                vertices = new HashMap();
                this.multiLevelNodes.put(nodeId, vertices);
            }
            if (!vertices.containsKey(level)) {
                Coordinate coordinate = this.getCoordinate(node);
                String label = String.format(levelnodeLabelFormat, node.getId(), level.shortName);
                OsmVertex vertex = new OsmVertex(this.graph, label, coordinate.x, coordinate.y, node.getId(), new NonLocalizedString(label), false, false);
                vertices.put(level, vertex);
                return vertex;
            }
            return (OsmVertex)vertices.get(level);
        }
    }

    private record StreetEdgePair(StreetEdge main, StreetEdge back) {
    }
}

