/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.ned;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.geotools.coverage.grid.GridCoverage2D;
import org.opengis.coverage.Coverage;
import org.opentripplanner.graph_builder.module.ned.DegreeGridNEDTileSource;
import org.opentripplanner.graph_builder.module.ned.GeotiffGridCoverageFactoryImpl;
import org.opentripplanner.graph_builder.module.ned.UnifiedGridCoverage;
import org.opentripplanner.graph_builder.module.ned.VerticalDatum;
import org.opentripplanner.graph_builder.services.ned.ElevationGridCoverageFactory;
import org.opentripplanner.graph_builder.services.ned.NEDTileSource;
import org.opentripplanner.routing.graph.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NEDGridCoverageFactoryImpl
implements ElevationGridCoverageFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NEDGridCoverageFactoryImpl.class);
    private static final String[] DATUM_FILENAMES = new String[]{"g2012a00.gtx", "g2012g00.gtx", "g2012h00.gtx", "g2012p00.gtx", "g2012s00.gtx", "g2012u00.gtx"};
    private final File cacheDirectory;
    public final NEDTileSource tileSource;
    private final List<GridCoverage2D> regionCoverages = new ArrayList<GridCoverage2D>();
    private List<VerticalDatum> datums;

    public NEDGridCoverageFactoryImpl(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
        this.tileSource = new DegreeGridNEDTileSource();
    }

    public NEDGridCoverageFactoryImpl(File cacheDirectory, NEDTileSource tileSource) {
        this.cacheDirectory = cacheDirectory;
        this.tileSource = tileSource;
    }

    @Override
    public Coverage getGridCoverage() {
        if (this.regionCoverages.size() == 0) {
            this.loadVerticalDatum();
            for (File path : this.tileSource.getNEDTiles()) {
                GeotiffGridCoverageFactoryImpl factory = new GeotiffGridCoverageFactoryImpl(path);
                this.regionCoverages.add(factory.getUninterpolatedGridCoverage());
            }
        }
        return new UnifiedGridCoverage(this.regionCoverages, this.datums);
    }

    @Override
    public double elevationUnitMultiplier() {
        return 1.0;
    }

    @Override
    public void checkInputs() {
        if (!this.cacheDirectory.exists()) {
            LOG.info("Cache directory {} does not exist, creating it.", (Object)this.cacheDirectory);
            if (!this.cacheDirectory.mkdirs()) {
                throw new RuntimeException("Failed to create cache directory for NED at " + this.cacheDirectory);
            }
        }
        if (!this.cacheDirectory.canRead() || !this.cacheDirectory.canWrite()) {
            throw new RuntimeException(String.format("Can't write and write NED cache at '%s'. Check permissions.", this.cacheDirectory));
        }
        boolean missingDatum = false;
        for (String filename : DATUM_FILENAMES) {
            File datumFile = new File(this.cacheDirectory, filename);
            if (datumFile.canRead()) continue;
            missingDatum = true;
        }
        if (missingDatum) {
            LOG.warn("OTP needs additional files (a vertical datum) to convert between NED elevations and OSM's WGS84 elevations.");
            try {
                this.fetchDatum();
            }
            catch (Exception ex) {
                LOG.error("Exception while fetching datum files from the web.");
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public void fetchData(Graph graph) {
        this.tileSource.fetchData(graph, this.cacheDirectory);
    }

    private void loadVerticalDatum() {
        if (this.datums == null) {
            this.datums = new ArrayList<VerticalDatum>();
            try {
                for (String filename : DATUM_FILENAMES) {
                    File datumFile = new File(this.cacheDirectory, filename);
                    VerticalDatum datum = VerticalDatum.fromGTX(new FileInputStream(datumFile));
                    this.datums.add(datum);
                }
            }
            catch (IOException e) {
                LOG.error("Datum file has disappeared since preflight inputs check.");
                throw new RuntimeException(e);
            }
        }
    }

    private void fetchDatum() throws Exception {
        LOG.info("Attempting to fetch datum files from OTP project web server...");
        URL datumUrl = new URL("http://dev.opentripplanner.org/resources/datum.zip");
        ZipInputStream zis = new ZipInputStream(datumUrl.openStream());
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            if (entry.isDirectory()) {
                throw new RuntimeException("ZIP files containing directories are not supported");
            }
            File file = new File(this.cacheDirectory, entry.getName());
            if (!file.getParentFile().equals(this.cacheDirectory)) {
                throw new RuntimeException("ZIP files containing directories are not supported");
            }
            LOG.info("decompressing {}", (Object)file);
            FileOutputStream os = new FileOutputStream(file);
            ByteStreams.copy((InputStream)zis, (OutputStream)os);
            ((OutputStream)os).close();
            entry = zis.getNextEntry();
        }
        zis.close();
        LOG.info("Done.");
    }
}

