/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.map;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.logging.ProgressTracker;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.map.StreetMatcher;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.service.TransitModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusRouteStreetMatcher
implements GraphBuilderModule {
    private static final Logger log = LoggerFactory.getLogger(BusRouteStreetMatcher.class);
    private final Graph graph;
    private final TransitModel transitModel;

    @Inject
    public BusRouteStreetMatcher(Graph graph, TransitModel transitModel) {
        this.graph = graph;
        this.transitModel = transitModel;
    }

    @Override
    public void buildGraph() {
        this.transitModel.index();
        this.graph.index(this.transitModel.getStopModel());
        StreetMatcher matcher = new StreetMatcher(this.graph);
        log.info("Finding corresponding street edges for trip patterns...");
        Collection<Route> allRoutes = this.transitModel.getTransitModelIndex().getAllRoutes();
        ProgressTracker progress = ProgressTracker.track("Match route to street edges", 10, allRoutes.size());
        log.info(progress.startMessage());
        for (Route route : allRoutes) {
            for (TripPattern pattern : this.transitModel.getTransitModelIndex().getPatternsForRoute().get((Object)route)) {
                if (!pattern.getMode().onStreet()) continue;
                log.debug("Matching {}", (Object)pattern);
                if (pattern.getGeometry() == null) continue;
                for (int i = 0; i < pattern.numHopGeometries(); ++i) {
                    LineString hopGeometry = pattern.getHopGeometry(i);
                    List<Edge> edges = matcher.match((Geometry)hopGeometry);
                    if (edges == null || edges.isEmpty()) {
                        log.warn("Could not match to street network: {}", (Object)pattern);
                        continue;
                    }
                    ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
                    for (Edge e : edges) {
                        coordinates.addAll(Arrays.asList(e.getGeometry().getCoordinates()));
                    }
                    Coordinate[] coordinateArray = new Coordinate[coordinates.size()];
                    LineString ls = GeometryUtils.getGeometryFactory().createLineString(coordinates.toArray(coordinateArray));
                    pattern.setHopGeometry(i, ls);
                }
            }
            progress.step(arg_0 -> ((Logger)log).info(arg_0));
        }
        log.info(progress.completeMessage());
    }

    @Override
    public void checkInputs() {
    }
}

