/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.islandpruning;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.routing.graph.index.StreetIndex;
import org.opentripplanner.street.model.vertex.OsmVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;

class Subgraph {
    private final Set<Vertex> streetVertexSet = new HashSet<Vertex>();
    private final Set<Vertex> stopsVertexSet = new HashSet<Vertex>();

    Subgraph() {
    }

    void addVertex(Vertex vertex) {
        if (vertex instanceof TransitStopVertex) {
            this.stopsVertexSet.add(vertex);
        } else {
            this.streetVertexSet.add(vertex);
        }
    }

    boolean contains(Vertex vertex) {
        return this.streetVertexSet.contains(vertex) || this.stopsVertexSet.contains(vertex);
    }

    int streetSize() {
        return this.streetVertexSet.size();
    }

    int stopSize() {
        return this.stopsVertexSet.size();
    }

    Vertex getRepresentativeVertex() {
        for (Vertex vertx : this.streetVertexSet) {
            if (!(vertx instanceof OsmVertex)) continue;
            return vertx;
        }
        return this.streetVertexSet.iterator().next();
    }

    Iterator<Vertex> streetIterator() {
        return this.streetVertexSet.iterator();
    }

    Iterator<Vertex> stopIterator() {
        return this.stopsVertexSet.iterator();
    }

    double vertexDistanceFromSubgraph(Vertex v, double searchRadius) {
        double d1 = this.streetVertexSet.stream().map(x -> SphericalDistanceLibrary.distance(x.getCoordinate(), v.getCoordinate())).min(Double::compareTo).orElse(searchRadius);
        double d2 = this.stopsVertexSet.stream().map(x -> SphericalDistanceLibrary.distance(x.getCoordinate(), v.getCoordinate())).min(Double::compareTo).orElse(searchRadius);
        return Math.min(d1, d2);
    }

    double distanceFromOtherGraph(StreetIndex index, double searchRadius) {
        Vertex vx2;
        Vertex v = this.getRepresentativeVertex();
        double xscale = Math.cos(v.getCoordinate().y * Math.PI / 180.0);
        double searchRadiusDegrees = SphericalDistanceLibrary.metersToDegrees(searchRadius);
        Envelope envelope = new Envelope();
        Iterator<Vertex> vIter = this.streetIterator();
        while (vIter.hasNext()) {
            vx2 = vIter.next();
            envelope.expandToInclude(vx2.getCoordinate());
        }
        vIter = this.stopIterator();
        while (vIter.hasNext()) {
            vx2 = vIter.next();
            envelope.expandToInclude(vx2.getCoordinate());
        }
        envelope.expandBy(searchRadiusDegrees / xscale, searchRadiusDegrees);
        return index.getVerticesForEnvelope(envelope).stream().filter(vx -> !this.contains((Vertex)vx)).map(vx -> this.vertexDistanceFromSubgraph((Vertex)vx, searchRadius)).min(Double::compareTo).orElse(searchRadius);
    }

    Geometry getGeometry() {
        ArrayList points = new ArrayList();
        GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
        Consumer<Vertex> vertexAdder = vertex -> points.add(geometryFactory.createPoint(vertex.getCoordinate()));
        this.streetIterator().forEachRemaining(vertexAdder);
        this.stopIterator().forEachRemaining(vertexAdder);
        return new MultiPoint(points.toArray(new Point[0]), geometryFactory);
    }
}

