/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.islandpruning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.GraphConnectivity;
import org.opentripplanner.graph_builder.issues.IsolatedStop;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.StreetLinkerModule;
import org.opentripplanner.graph_builder.module.islandpruning.GraphIsland;
import org.opentripplanner.graph_builder.module.islandpruning.PrunedStopIsland;
import org.opentripplanner.graph_builder.module.islandpruning.Subgraph;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.index.StreetIndex;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.AreaEdge;
import org.opentripplanner.street.model.edge.AreaEdgeList;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.ElevatorEdge;
import org.opentripplanner.street.model.edge.FreeEdge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.StreetTransitEntityLink;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.service.TransitModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PruneIslands
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(PruneIslands.class);
    private final Graph graph;
    private final TransitModel transitModel;
    private final DataImportIssueStore issueStore;
    private final StreetLinkerModule streetLinkerModule;
    private int pruningThresholdWithoutStops;
    private int pruningThresholdWithStops;
    private int adaptivePruningDistance;
    private double adaptivePruningFactor;
    private VertexLinker vertexLinker;
    private StreetIndex streetIndex;

    public PruneIslands(Graph graph, TransitModel transitModel, DataImportIssueStore issueStore, StreetLinkerModule streetLinkerModule) {
        this.graph = graph;
        this.transitModel = transitModel;
        this.issueStore = issueStore;
        this.streetLinkerModule = streetLinkerModule;
    }

    @Override
    public void buildGraph() {
        LOG.info("Pruning islands and areas isolated by nothru edges in street network");
        LOG.info("Threshold with stops {}, without stops {}, adaptive coeff {} and distance {}", new Object[]{this.pruningThresholdWithStops, this.pruningThresholdWithoutStops, this.adaptivePruningFactor, this.adaptivePruningDistance});
        this.vertexLinker = this.graph.getLinkerSafe(this.transitModel.getStopModel());
        this.streetIndex = this.graph.getStreetIndexSafe(this.transitModel.getStopModel());
        this.pruneIslands(TraverseMode.BICYCLE);
        this.pruneIslands(TraverseMode.WALK);
        this.pruneIslands(TraverseMode.CAR);
        if (this.streetLinkerModule != null) {
            LOG.info("Reconnecting stops");
            this.streetLinkerModule.linkTransitStops(this.graph, this.transitModel);
            int isolated = 0;
            for (TransitStopVertex tStop : this.graph.getVerticesOfType(TransitStopVertex.class)) {
                if (tStop.getDegreeOut() + tStop.getDegreeIn() != 0) continue;
                this.issueStore.add(new IsolatedStop(tStop));
                ++isolated;
            }
            LOG.info("{} stops remain isolated", (Object)isolated);
        }
        List<AreaEdge> areaEdges = this.graph.getEdgesOfType(AreaEdge.class);
        HashSet<AreaEdgeList> areas = new HashSet<AreaEdgeList>();
        HashSet<Vertex> visibilityVertices = new HashSet<Vertex>();
        for (AreaEdge ae : areaEdges) {
            areas.add(ae.getArea());
        }
        for (AreaEdgeList a : areas) {
            for (Vertex vertex : a.visibilityVertices) {
                visibilityVertices.add(vertex);
            }
        }
        int removed = 0;
        LinkedList<Vertex> toRemove = new LinkedList<Vertex>();
        for (Vertex vertex : this.graph.getVerticesOfType(StreetVertex.class)) {
            if (vertex.getDegreeOut() + vertex.getDegreeIn() != 0 || visibilityVertices.contains(vertex)) continue;
            toRemove.add(vertex);
        }
        for (Vertex vertex : toRemove) {
            this.graph.remove(vertex);
            ++removed;
        }
        LOG.info("Removed {} edgeless street vertices", (Object)removed);
    }

    @Override
    public void checkInputs() {
    }

    public void setPruningThresholdIslandWithoutStops(int pruningThresholdIslandWithoutStops) {
        this.pruningThresholdWithoutStops = pruningThresholdIslandWithoutStops;
    }

    public void setPruningThresholdIslandWithStops(int pruningThresholdIslandWithStops) {
        this.pruningThresholdWithStops = pruningThresholdIslandWithStops;
    }

    public void setAdaptivePruningDistance(int adaptivePruningDistance) {
        this.adaptivePruningDistance = adaptivePruningDistance;
    }

    public void setAdaptivePruningFactor(double adaptivePruningFactor) {
        this.adaptivePruningFactor = adaptivePruningFactor;
    }

    private void pruneIslands(TraverseMode traverseMode) {
        LOG.debug("nothru pruning");
        HashMap<Vertex, Subgraph> subgraphs = new HashMap<Vertex, Subgraph>();
        HashMap<Vertex, Subgraph> extgraphs = new HashMap<Vertex, Subgraph>();
        HashMap<Vertex, ArrayList<Vertex>> neighborsForVertex = new HashMap<Vertex, ArrayList<Vertex>>();
        HashMap<Edge, Boolean> isolated = new HashMap<Edge, Boolean>();
        ArrayList<Subgraph> islands = new ArrayList<Subgraph>();
        this.collectNeighbourVertices(neighborsForVertex, traverseMode, false);
        int count = this.collectSubGraphs(neighborsForVertex, subgraphs, null, null);
        LOG.info("Islands when {} noThruTraffic is considered: {}", (Object)traverseMode, (Object)count);
        this.collectNeighbourVertices(neighborsForVertex, traverseMode, true);
        count = this.collectSubGraphs(neighborsForVertex, extgraphs, null, islands);
        LOG.info("Islands when {} noThruTraffic is ignored: {}", (Object)traverseMode, (Object)count);
        this.processIslands(islands, isolated, true, traverseMode);
        extgraphs = new HashMap();
        islands = new ArrayList();
        this.collectSubGraphs(neighborsForVertex, extgraphs, subgraphs, islands);
        count = this.collectSubGraphs(neighborsForVertex, extgraphs, null, islands);
        LOG.info("{} noThruTraffic island count: {}", (Object)traverseMode, (Object)count);
        LOG.info("Total {} sub graphs found", (Object)islands.size());
        count = this.processIslands(islands, isolated, false, traverseMode);
        LOG.info("Modified {} islands", (Object)count);
    }

    private int processIslands(ArrayList<Subgraph> islands, Map<Edge, Boolean> isolated, boolean markIsolated, TraverseMode traverseMode) {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("isolated", 0);
        stats.put("removed", 0);
        stats.put("noThru", 0);
        stats.put("restricted", 0);
        Subgraph largest = null;
        int maxSize = 0;
        for (Subgraph island : islands) {
            int streetCount = island.streetSize();
            if (streetCount < maxSize) continue;
            maxSize = streetCount;
            largest = island;
        }
        int count = 0;
        int islandsWithStops = 0;
        int islandsWithStopsChanged = 0;
        for (Subgraph island : islands) {
            double sizeCoeff;
            if (island == largest) continue;
            if (island.stopSize() > 0) {
                double sizeCoeff2;
                ++islandsWithStops;
                boolean onlyFerry = true;
                Iterator<Vertex> vIter = island.stopIterator();
                while (vIter.hasNext()) {
                    TransitStopVertex v = (TransitStopVertex)vIter.next();
                    Set<TransitMode> modes = v.getModes();
                    if (modes.isEmpty() || modes.contains((Object)TransitMode.FERRY)) continue;
                    onlyFerry = false;
                    break;
                }
                if (onlyFerry || !((double)island.streetSize() < (double)this.pruningThresholdWithStops * this.adaptivePruningFactor)) continue;
                double d = sizeCoeff2 = this.adaptivePruningFactor > 1.0 ? island.distanceFromOtherGraph(this.streetIndex, this.adaptivePruningDistance) / (double)this.adaptivePruningDistance : 1.0;
                if (!((double)island.streetSize() * sizeCoeff2 < (double)this.pruningThresholdWithStops) || !this.restrictOrRemove(island, isolated, stats, markIsolated, traverseMode)) continue;
                ++islandsWithStopsChanged;
                ++count;
                continue;
            }
            if (!((double)island.streetSize() < (double)this.pruningThresholdWithoutStops * this.adaptivePruningFactor)) continue;
            double d = sizeCoeff = this.adaptivePruningFactor > 1.0 ? island.distanceFromOtherGraph(this.streetIndex, this.adaptivePruningDistance) / (double)this.adaptivePruningDistance : 1.0;
            if (!((double)island.streetSize() * sizeCoeff < (double)this.pruningThresholdWithoutStops) || !this.restrictOrRemove(island, isolated, stats, markIsolated, traverseMode)) continue;
            ++count;
        }
        if (markIsolated) {
            LOG.info("Detected {} isolated edges", stats.get("isolated"));
        } else {
            LOG.info("Number of islands with stops: {}", (Object)islandsWithStops);
            LOG.warn("Modified connectivity of {} islands with stops", (Object)islandsWithStopsChanged);
            LOG.info("Removed {} edges", stats.get("removed"));
            LOG.info("Removed traversal mode from {} edges", stats.get("restricted"));
            LOG.info("Converted {} edges to noThruTraffic", stats.get("noThru"));
            this.issueStore.add(new GraphConnectivity(traverseMode, islands.size(), islandsWithStops, islandsWithStopsChanged, ((Integer)stats.get("removed")).intValue(), ((Integer)stats.get("restricted")).intValue(), ((Integer)stats.get("noThru")).intValue()));
        }
        return count;
    }

    private void collectNeighbourVertices(Map<Vertex, ArrayList<Vertex>> neighborsForVertex, TraverseMode traverseMode, boolean shouldMatchNoThruType) {
        StreetMode streetMode = switch (traverseMode) {
            case TraverseMode.WALK -> StreetMode.WALK;
            case TraverseMode.BICYCLE -> StreetMode.BIKE;
            case TraverseMode.CAR -> StreetMode.CAR;
            default -> throw new IllegalArgumentException();
        };
        StreetSearchRequest request = StreetSearchRequest.of().withMode(streetMode).build();
        for (Vertex gv : this.graph.getVertices()) {
            if (!(gv instanceof StreetVertex)) continue;
            State s0 = new State(gv, request);
            for (Edge e : gv.getOutgoing()) {
                State s1;
                if (!(e instanceof StreetEdge) && !(e instanceof ElevatorEdge) && !(e instanceof FreeEdge) && !(e instanceof StreetTransitEntityLink) || e instanceof StreetEdge && shouldMatchNoThruType != ((StreetEdge)e).isNoThruTraffic(traverseMode) || (s1 = e.traverse(s0)) == null) continue;
                Vertex out = s1.getVertex();
                ArrayList vertexList = neighborsForVertex.computeIfAbsent(gv, k -> new ArrayList());
                vertexList.add(out);
                vertexList = neighborsForVertex.computeIfAbsent(out, k -> new ArrayList());
                vertexList.add(gv);
            }
        }
    }

    private int collectSubGraphs(Map<Vertex, ArrayList<Vertex>> neighborsForVertex, Map<Vertex, Subgraph> newgraphs, Map<Vertex, Subgraph> subgraphs, ArrayList<Subgraph> islands) {
        int count = 0;
        for (Vertex gv : this.graph.getVertices()) {
            if (!(gv instanceof StreetVertex) || subgraphs != null && !subgraphs.containsKey(gv) || newgraphs.containsKey(gv) || !neighborsForVertex.containsKey(gv)) continue;
            Subgraph subgraph = this.computeConnectedSubgraph(neighborsForVertex, gv, subgraphs, newgraphs);
            Iterator<Vertex> vIter = subgraph.streetIterator();
            while (vIter.hasNext()) {
                Vertex subnode = vIter.next();
                newgraphs.put(subnode, subgraph);
            }
            if (islands != null) {
                islands.add(subgraph);
            }
            ++count;
        }
        return count;
    }

    private boolean restrictOrRemove(Subgraph island, Map<Edge, Boolean> isolated, Map<String, Integer> stats, boolean markIsolated, TraverseMode traverseMode) {
        int nothru = 0;
        int removed = 0;
        int restricted = 0;
        Iterator<Vertex> vIter = island.streetIterator();
        while (vIter.hasNext()) {
            Vertex v = vIter.next();
            ArrayList<Edge> outgoing = new ArrayList<Edge>(v.getOutgoing());
            for (Edge e : outgoing) {
                if (!(e instanceof StreetEdge)) continue;
                if (markIsolated) {
                    isolated.put(e, true);
                    stats.put("isolated", stats.get("isolated") + 1);
                    continue;
                }
                StreetEdge pse = (StreetEdge)e;
                if (!isolated.containsKey(e)) {
                    boolean changed = false;
                    if (traverseMode == TraverseMode.CAR) {
                        if (!pse.isMotorVehicleNoThruTraffic()) {
                            pse.setMotorVehicleNoThruTraffic(true);
                            changed = true;
                        }
                    } else if (traverseMode == TraverseMode.BICYCLE) {
                        if (!pse.isBicycleNoThruTraffic()) {
                            pse.setBicycleNoThruTraffic(true);
                            changed = true;
                        }
                    } else if (traverseMode == TraverseMode.WALK && !pse.isWalkNoThruTraffic()) {
                        pse.setWalkNoThruTraffic(true);
                        changed = true;
                    }
                    if (!changed) continue;
                    stats.put("noThru", stats.get("noThru") + 1);
                    ++nothru;
                    continue;
                }
                StreetTraversalPermission permission = pse.getPermission();
                boolean changed = false;
                if (traverseMode == TraverseMode.CAR) {
                    if (permission.allows(StreetTraversalPermission.CAR)) {
                        permission = permission.remove(StreetTraversalPermission.CAR);
                        changed = true;
                    }
                } else if (traverseMode == TraverseMode.BICYCLE) {
                    if (permission.allows(StreetTraversalPermission.BICYCLE)) {
                        permission = permission.remove(StreetTraversalPermission.BICYCLE);
                        changed = true;
                    }
                } else if (traverseMode == TraverseMode.WALK && permission.allows(StreetTraversalPermission.PEDESTRIAN)) {
                    permission = permission.remove(StreetTraversalPermission.PEDESTRIAN);
                    changed = true;
                }
                if (!changed) continue;
                if (permission == StreetTraversalPermission.NONE) {
                    this.vertexLinker.removePermanentEdgeFromIndex(pse);
                    this.graph.removeEdge(pse);
                    stats.put("removed", stats.get("removed") + 1);
                    ++removed;
                    continue;
                }
                pse.setPermission(permission);
                stats.put("restricted", stats.get("restricted") + 1);
                ++restricted;
            }
        }
        if (markIsolated) {
            return false;
        }
        if (stats.isEmpty()) {
            return false;
        }
        if (traverseMode == TraverseMode.WALK) {
            ArrayList<String> stopLabels = new ArrayList<String>();
            Iterator<Vertex> vIter2 = island.stopIterator();
            while (vIter2.hasNext()) {
                Vertex v = vIter2.next();
                stopLabels.add(v.getLabel());
                ArrayList<Edge> edges = new ArrayList<Edge>(v.getOutgoing());
                edges.addAll(v.getIncoming());
                for (Edge e : edges) {
                    this.graph.removeEdge(e);
                }
            }
            if (island.stopSize() > 0) {
                this.issueStore.add(new PrunedStopIsland(island, nothru, restricted, removed, String.join((CharSequence)", ", stopLabels)));
            }
        }
        this.issueStore.add(new GraphIsland(island, nothru, restricted, removed, traverseMode.name()));
        return true;
    }

    private Subgraph computeConnectedSubgraph(Map<Vertex, ArrayList<Vertex>> neighborsForVertex, Vertex startVertex, Map<Vertex, Subgraph> anchors, Map<Vertex, Subgraph> alreadyMapped) {
        Subgraph subgraph = new Subgraph();
        LinkedList<Vertex> q = new LinkedList<Vertex>();
        Subgraph anchor = null;
        if (anchors != null) {
            anchor = anchors.get(startVertex);
        }
        q.add(startVertex);
        while (!q.isEmpty()) {
            Vertex vertex = (Vertex)q.poll();
            for (Vertex neighbor : neighborsForVertex.get(vertex)) {
                Subgraph compare;
                if (subgraph.contains(neighbor) || alreadyMapped.containsKey(neighbor) || anchor != null && (compare = anchors.get(neighbor)) != null && compare != anchor) continue;
                subgraph.addVertex(neighbor);
                q.add(neighbor);
            }
        }
        return subgraph;
    }
}

