/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.geometry;

import jakarta.inject.Inject;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.framework.logging.ProgressTracker;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.service.worldenvelope.model.WorldEnvelope;
import org.opentripplanner.service.worldenvelope.model.WorldEnvelopeBuilder;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TransitModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateWorldEnvelopeModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(CalculateWorldEnvelopeModule.class);
    private static final int LOG_EVERY_N_COORDINATE = 1000000;
    private final Graph graph;
    private final TransitModel transitModel;
    private final WorldEnvelopeRepository worldEnvelopeRepository;

    @Inject
    public CalculateWorldEnvelopeModule(Graph graph, TransitModel transitModel, WorldEnvelopeRepository worldEnvelopeRepository) {
        this.graph = graph;
        this.transitModel = transitModel;
        this.worldEnvelopeRepository = worldEnvelopeRepository;
    }

    @Override
    public void buildGraph() {
        Collection<Vertex> vertices = this.graph.getVertices();
        Collection<StopLocation> stops = this.transitModel.getStopModel().listStopLocations();
        WorldEnvelope envelope = CalculateWorldEnvelopeModule.build(vertices, stops);
        this.worldEnvelopeRepository.saveEnvelope(envelope);
    }

    @Override
    public void checkInputs() {
    }

    static WorldEnvelope build(Collection<? extends Vertex> vertices, Collection<? extends StopLocation> stops) {
        ProgressTracker progressTracker = ProgressTracker.track("CalculateWorldEnvelope", 1000000, vertices.size() + stops.size());
        WorldEnvelopeBuilder e = WorldEnvelope.of();
        for (Vertex vertex : vertices) {
            Coordinate c = vertex.getCoordinate();
            e.expandToIncludeStreetEntities(c.y, c.x);
            progressTracker.step(msg -> LOG.info(msg));
        }
        e.expandToIncludeTransitEntities(stops, s -> s.getCoordinate().latitude(), s -> s.getCoordinate().longitude());
        progressTracker.steps(stops.size(), msg -> LOG.info(msg));
        LOG.info(progressTracker.completeMessage());
        return e.build();
    }
}

