/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.configure;

import dagger.BindsInstance;
import dagger.Component;
import jakarta.inject.Singleton;
import java.time.ZoneId;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.ext.dataoverlay.EdgeUpdaterModule;
import org.opentripplanner.ext.flex.FlexLocationsToStreetEdgesMapper;
import org.opentripplanner.ext.transferanalyzer.DirectTransferAnalyzer;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.issue.report.DataImportIssueReporter;
import org.opentripplanner.graph_builder.module.DirectTransferGenerator;
import org.opentripplanner.graph_builder.module.GraphCoherencyCheckerModule;
import org.opentripplanner.graph_builder.module.OsmBoardingLocationsModule;
import org.opentripplanner.graph_builder.module.StreetLinkerModule;
import org.opentripplanner.graph_builder.module.TimeZoneAdjusterModule;
import org.opentripplanner.graph_builder.module.TripPatternNamer;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules;
import org.opentripplanner.graph_builder.module.geometry.CalculateWorldEnvelopeModule;
import org.opentripplanner.graph_builder.module.islandpruning.PruneIslands;
import org.opentripplanner.graph_builder.module.map.BusRouteStreetMatcher;
import org.opentripplanner.graph_builder.module.ned.ElevationModule;
import org.opentripplanner.graph_builder.module.osm.OpenStreetMapModule;
import org.opentripplanner.gtfs.graphbuilder.GtfsModule;
import org.opentripplanner.netex.NetexModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.transit.service.TransitModel;

@Singleton
@Component(modules={GraphBuilderModules.class})
public interface GraphBuilderFactory {
    public GraphBuilder graphBuilder();

    public OpenStreetMapModule openStreetMapModule();

    public GtfsModule gtfsModule();

    public NetexModule netexModule();

    public TimeZoneAdjusterModule timeZoneAdjusterModule();

    public TripPatternNamer tripPatternNamer();

    public BusRouteStreetMatcher busRouteStreetMatcher();

    public OsmBoardingLocationsModule osmBoardingLocationsModule();

    public StreetLinkerModule streetLinkerModule();

    public PruneIslands pruneIslands();

    public List<ElevationModule> elevationModules();

    public FlexLocationsToStreetEdgesMapper flexLocationsToStreetEdgesMapper();

    public DirectTransferGenerator directTransferGenerator();

    public DirectTransferAnalyzer directTransferAnalyzer();

    public GraphCoherencyCheckerModule graphCoherencyCheckerModule();

    public EdgeUpdaterModule dataOverlayFactory();

    public DataImportIssueReporter dataImportIssueReporter();

    public CalculateWorldEnvelopeModule calculateWorldEnvelopeModule();

    @Component.Builder
    public static interface Builder {
        @BindsInstance
        public Builder config(BuildConfig var1);

        @BindsInstance
        public Builder graph(Graph var1);

        @BindsInstance
        public Builder transitModel(TransitModel var1);

        @BindsInstance
        public Builder worldEnvelopeRepository(WorldEnvelopeRepository var1);

        @BindsInstance
        public Builder dataSources(GraphBuilderDataSources var1);

        @BindsInstance
        public Builder timeZoneId(@Nullable ZoneId var1);

        public GraphBuilderFactory build();
    }
}

