/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import java.time.ZoneId;
import java.util.List;
import javax.inject.Provider;
import org.opentripplanner.ext.dataoverlay.EdgeUpdaterModule;
import org.opentripplanner.ext.flex.FlexLocationsToStreetEdgesMapper;
import org.opentripplanner.ext.transferanalyzer.DirectTransferAnalyzer;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.report.DataImportIssueReporter;
import org.opentripplanner.graph_builder.module.DirectTransferGenerator;
import org.opentripplanner.graph_builder.module.GraphCoherencyCheckerModule;
import org.opentripplanner.graph_builder.module.OsmBoardingLocationsModule;
import org.opentripplanner.graph_builder.module.StreetLinkerModule;
import org.opentripplanner.graph_builder.module.TimeZoneAdjusterModule;
import org.opentripplanner.graph_builder.module.TripPatternNamer;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideDataImportIssuesStoreFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideDataImportIssuesToHTMLFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideDataOverlayFactoryFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideDirectTransferAnalyzerFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideDirectTransferGeneratorFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideElevationModulesFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideGtfsModuleFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideNetexModuleFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideOpenStreetMapModuleFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvidePruneIslandsFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideStreetLinkerModuleFactory;
import org.opentripplanner.graph_builder.module.geometry.CalculateWorldEnvelopeModule;
import org.opentripplanner.graph_builder.module.islandpruning.PruneIslands;
import org.opentripplanner.graph_builder.module.map.BusRouteStreetMatcher;
import org.opentripplanner.graph_builder.module.ned.ElevationModule;
import org.opentripplanner.graph_builder.module.osm.OpenStreetMapModule;
import org.opentripplanner.gtfs.graphbuilder.GtfsModule;
import org.opentripplanner.netex.NetexModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.transit.service.TransitModel;

@DaggerGenerated
public final class DaggerGraphBuilderFactory {
    private DaggerGraphBuilderFactory() {
    }

    public static GraphBuilderFactory.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements GraphBuilderFactory.Builder {
        private BuildConfig config;
        private Graph graph;
        private TransitModel transitModel;
        private WorldEnvelopeRepository worldEnvelopeRepository;
        private GraphBuilderDataSources dataSources;
        private ZoneId timeZoneId;

        private Builder() {
        }

        @Override
        public Builder config(BuildConfig config) {
            this.config = (BuildConfig)Preconditions.checkNotNull((Object)config);
            return this;
        }

        @Override
        public Builder graph(Graph graph) {
            this.graph = (Graph)Preconditions.checkNotNull((Object)graph);
            return this;
        }

        @Override
        public Builder transitModel(TransitModel transitModel) {
            this.transitModel = (TransitModel)Preconditions.checkNotNull((Object)transitModel);
            return this;
        }

        @Override
        public Builder worldEnvelopeRepository(WorldEnvelopeRepository worldEnvelopeRepository) {
            this.worldEnvelopeRepository = (WorldEnvelopeRepository)Preconditions.checkNotNull((Object)worldEnvelopeRepository);
            return this;
        }

        @Override
        public Builder dataSources(GraphBuilderDataSources graphBuilderDataSources) {
            this.dataSources = (GraphBuilderDataSources)Preconditions.checkNotNull((Object)graphBuilderDataSources);
            return this;
        }

        @Override
        public Builder timeZoneId(ZoneId zoneId) {
            this.timeZoneId = zoneId;
            return this;
        }

        @Override
        public GraphBuilderFactory build() {
            Preconditions.checkBuilderRequirement((Object)this.config, BuildConfig.class);
            Preconditions.checkBuilderRequirement((Object)this.graph, Graph.class);
            Preconditions.checkBuilderRequirement((Object)this.transitModel, TransitModel.class);
            Preconditions.checkBuilderRequirement((Object)this.worldEnvelopeRepository, WorldEnvelopeRepository.class);
            Preconditions.checkBuilderRequirement((Object)this.dataSources, GraphBuilderDataSources.class);
            return new GraphBuilderFactoryImpl(this.config, this.graph, this.transitModel, this.worldEnvelopeRepository, this.dataSources, this.timeZoneId);
        }
    }

    private static final class GraphBuilderFactoryImpl
    implements GraphBuilderFactory {
        private final Graph graph;
        private final TransitModel transitModel;
        private final WorldEnvelopeRepository worldEnvelopeRepository;
        private final GraphBuilderFactoryImpl graphBuilderFactoryImpl = this;
        private Provider<DataImportIssueStore> provideDataImportIssuesStoreProvider;
        private Provider<GraphBuilderDataSources> dataSourcesProvider;
        private Provider<BuildConfig> configProvider;
        private Provider<Graph> graphProvider;
        private Provider<OpenStreetMapModule> provideOpenStreetMapModuleProvider;
        private Provider<TransitModel> transitModelProvider;
        private Provider<GtfsModule> provideGtfsModuleProvider;
        private Provider<NetexModule> provideNetexModuleProvider;
        private Provider<StreetLinkerModule> provideStreetLinkerModuleProvider;
        private Provider<PruneIslands> providePruneIslandsProvider;
        private Provider<List<ElevationModule>> provideElevationModulesProvider;
        private Provider<DirectTransferGenerator> provideDirectTransferGeneratorProvider;
        private Provider<DirectTransferAnalyzer> provideDirectTransferAnalyzerProvider;
        private Provider<EdgeUpdaterModule> provideDataOverlayFactoryProvider;
        private Provider<DataImportIssueReporter> provideDataImportIssuesToHTMLProvider;

        private GraphBuilderFactoryImpl(BuildConfig configParam, Graph graphParam, TransitModel transitModelParam, WorldEnvelopeRepository worldEnvelopeRepositoryParam, GraphBuilderDataSources dataSourcesParam, ZoneId timeZoneIdParam) {
            this.graph = graphParam;
            this.transitModel = transitModelParam;
            this.worldEnvelopeRepository = worldEnvelopeRepositoryParam;
            this.initialize(configParam, graphParam, transitModelParam, worldEnvelopeRepositoryParam, dataSourcesParam, timeZoneIdParam);
        }

        private void initialize(BuildConfig configParam, Graph graphParam, TransitModel transitModelParam, WorldEnvelopeRepository worldEnvelopeRepositoryParam, GraphBuilderDataSources dataSourcesParam, ZoneId timeZoneIdParam) {
            this.provideDataImportIssuesStoreProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideDataImportIssuesStoreFactory.create());
            this.dataSourcesProvider = InstanceFactory.create((Object)dataSourcesParam);
            this.configProvider = InstanceFactory.create((Object)configParam);
            this.graphProvider = InstanceFactory.create((Object)graphParam);
            this.provideOpenStreetMapModuleProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideOpenStreetMapModuleFactory.create(this.dataSourcesProvider, this.configProvider, this.graphProvider, this.provideDataImportIssuesStoreProvider));
            this.transitModelProvider = InstanceFactory.create((Object)transitModelParam);
            this.provideGtfsModuleProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideGtfsModuleFactory.create(this.dataSourcesProvider, this.configProvider, this.graphProvider, this.transitModelProvider, this.provideDataImportIssuesStoreProvider));
            this.provideNetexModuleProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideNetexModuleFactory.create(this.dataSourcesProvider, this.configProvider, this.graphProvider, this.transitModelProvider, this.provideDataImportIssuesStoreProvider));
            this.provideStreetLinkerModuleProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideStreetLinkerModuleFactory.create(this.configProvider, this.graphProvider, this.transitModelProvider, this.provideDataImportIssuesStoreProvider));
            this.providePruneIslandsProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvidePruneIslandsFactory.create(this.configProvider, this.graphProvider, this.transitModelProvider, this.provideDataImportIssuesStoreProvider));
            this.provideElevationModulesProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideElevationModulesFactory.create(this.configProvider, this.dataSourcesProvider, this.graphProvider, this.provideOpenStreetMapModuleProvider, this.provideDataImportIssuesStoreProvider));
            this.provideDirectTransferGeneratorProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideDirectTransferGeneratorFactory.create(this.configProvider, this.graphProvider, this.transitModelProvider, this.provideDataImportIssuesStoreProvider));
            this.provideDirectTransferAnalyzerProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideDirectTransferAnalyzerFactory.create(this.configProvider, this.graphProvider, this.transitModelProvider, this.provideDataImportIssuesStoreProvider));
            this.provideDataOverlayFactoryProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideDataOverlayFactoryFactory.create(this.configProvider, this.graphProvider));
            this.provideDataImportIssuesToHTMLProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideDataImportIssuesToHTMLFactory.create(this.dataSourcesProvider, this.configProvider, this.provideDataImportIssuesStoreProvider));
        }

        @Override
        public GraphBuilder graphBuilder() {
            return new GraphBuilder(this.graph, this.transitModel, (DataImportIssueStore)this.provideDataImportIssuesStoreProvider.get());
        }

        @Override
        public OpenStreetMapModule openStreetMapModule() {
            return (OpenStreetMapModule)this.provideOpenStreetMapModuleProvider.get();
        }

        @Override
        public GtfsModule gtfsModule() {
            return (GtfsModule)this.provideGtfsModuleProvider.get();
        }

        @Override
        public NetexModule netexModule() {
            return (NetexModule)this.provideNetexModuleProvider.get();
        }

        @Override
        public TimeZoneAdjusterModule timeZoneAdjusterModule() {
            return new TimeZoneAdjusterModule(this.transitModel);
        }

        @Override
        public TripPatternNamer tripPatternNamer() {
            return new TripPatternNamer(this.transitModel);
        }

        @Override
        public BusRouteStreetMatcher busRouteStreetMatcher() {
            return new BusRouteStreetMatcher(this.graph, this.transitModel);
        }

        @Override
        public OsmBoardingLocationsModule osmBoardingLocationsModule() {
            return new OsmBoardingLocationsModule(this.graph, this.transitModel);
        }

        @Override
        public StreetLinkerModule streetLinkerModule() {
            return (StreetLinkerModule)this.provideStreetLinkerModuleProvider.get();
        }

        @Override
        public PruneIslands pruneIslands() {
            return (PruneIslands)this.providePruneIslandsProvider.get();
        }

        @Override
        public List<ElevationModule> elevationModules() {
            return (List)this.provideElevationModulesProvider.get();
        }

        @Override
        public FlexLocationsToStreetEdgesMapper flexLocationsToStreetEdgesMapper() {
            return new FlexLocationsToStreetEdgesMapper(this.graph, this.transitModel);
        }

        @Override
        public DirectTransferGenerator directTransferGenerator() {
            return (DirectTransferGenerator)this.provideDirectTransferGeneratorProvider.get();
        }

        @Override
        public DirectTransferAnalyzer directTransferAnalyzer() {
            return (DirectTransferAnalyzer)this.provideDirectTransferAnalyzerProvider.get();
        }

        @Override
        public GraphCoherencyCheckerModule graphCoherencyCheckerModule() {
            return new GraphCoherencyCheckerModule(this.graph, (DataImportIssueStore)this.provideDataImportIssuesStoreProvider.get());
        }

        @Override
        public EdgeUpdaterModule dataOverlayFactory() {
            return (EdgeUpdaterModule)this.provideDataOverlayFactoryProvider.get();
        }

        @Override
        public DataImportIssueReporter dataImportIssueReporter() {
            return (DataImportIssueReporter)this.provideDataImportIssuesToHTMLProvider.get();
        }

        @Override
        public CalculateWorldEnvelopeModule calculateWorldEnvelopeModule() {
            return new CalculateWorldEnvelopeModule(this.graph, this.transitModel, this.worldEnvelopeRepository);
        }
    }
}

