/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import com.google.common.collect.ArrayListMultimap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.astar.model.ShortestPathTree;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;
import org.opentripplanner.astar.strategy.ComposingSkipEdgeStrategy;
import org.opentripplanner.astar.strategy.DurationSkipEdgeStrategy;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.ext.vehicletostopheuristics.BikeToStopSkipEdgeStrategy;
import org.opentripplanner.ext.vehicletostopheuristics.VehicleToStopSkipEdgeStrategy;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.graph_builder.module.MinMap;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.WalkPreferences;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.graphfinder.DirectGraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.TemporaryStreetLocation;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.StreetSearchBuilder;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.request.StreetSearchRequest;
import org.opentripplanner.street.search.request.StreetSearchRequestMapper;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.strategy.DominanceFunctions;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TransitService;

public class NearbyStopFinder {
    public final boolean useStreets;
    private final TransitService transitService;
    private final Duration durationLimit;
    private final DataOverlayContext dataOverlayContext;
    private DirectGraphFinder directGraphFinder;

    public NearbyStopFinder(TransitService transitService, Duration durationLimit, DataOverlayContext dataOverlayContext, boolean useStreets) {
        this.transitService = transitService;
        this.dataOverlayContext = dataOverlayContext;
        this.useStreets = useStreets;
        this.durationLimit = durationLimit;
        if (!useStreets) {
            this.directGraphFinder = new DirectGraphFinder(transitService::findRegularStop);
        }
    }

    public Set<NearbyStop> findNearbyStopsConsideringPatterns(Vertex vertex, RouteRequest routingRequest, StreetRequest streetRequest, boolean reverseDirection) {
        MinMap<TripPattern, NearbyStop> closestStopForPattern = new MinMap<TripPattern, NearbyStop>();
        MinMap<FlexTrip, NearbyStop> closestStopForFlexTrip = new MinMap<FlexTrip, NearbyStop>();
        for (NearbyStop nearbyStop : this.findNearbyStops(vertex, routingRequest, streetRequest, reverseDirection)) {
            StopLocation ts1 = nearbyStop.stop;
            if (ts1 instanceof RegularStop) {
                for (TripPattern tripPattern : this.transitService.getPatternsForStop(ts1)) {
                    if (!(reverseDirection ? tripPattern.canAlight(nearbyStop.stop) : tripPattern.canBoard(nearbyStop.stop))) continue;
                    closestStopForPattern.putMin(tripPattern, nearbyStop);
                }
            }
            if (!OTPFeature.FlexRouting.isOn()) continue;
            for (FlexTrip flexTrip : this.transitService.getFlexIndex().getFlexTripsByStop(ts1)) {
                if (!(reverseDirection ? flexTrip.isAlightingPossible(nearbyStop) : flexTrip.isBoardingPossible(nearbyStop))) continue;
                closestStopForFlexTrip.putMin(flexTrip, nearbyStop);
            }
        }
        HashSet<NearbyStop> uniqueStops = new HashSet<NearbyStop>();
        uniqueStops.addAll(closestStopForFlexTrip.values());
        uniqueStops.addAll(closestStopForPattern.values());
        return uniqueStops;
    }

    public List<NearbyStop> findNearbyStops(Vertex vertex, RouteRequest routingRequest, StreetRequest streetRequest, boolean reverseDirection) {
        if (this.useStreets) {
            return this.findNearbyStopsViaStreets(Set.of(vertex), reverseDirection, routingRequest, streetRequest);
        }
        return this.findNearbyStopsViaDirectTransfers(vertex);
    }

    public List<NearbyStop> findNearbyStopsViaStreets(Set<Vertex> originVertices, boolean reverseDirection, RouteRequest request, StreetRequest streetRequest) {
        List<NearbyStop> stopsFound = NearbyStopFinder.createDirectlyConnectedStops(originVertices, reverseDirection, request, streetRequest);
        if (streetRequest.mode() == StreetMode.NOT_SET) {
            return stopsFound;
        }
        ShortestPathTree spt = ((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)StreetSearchBuilder.of().setSkipEdgeStrategy(this.getSkipEdgeStrategy(reverseDirection, request))).setDominanceFunction(new DominanceFunctions.MinimumWeight())).setRequest(request).setArriveBy(reverseDirection)).setStreetRequest(streetRequest).setFrom(reverseDirection ? null : originVertices)).setTo(reverseDirection ? originVertices : null)).setDataOverlayContext(this.dataOverlayContext).getShortestPathTree();
        ArrayListMultimap locationsMap = ArrayListMultimap.create();
        if (spt != null) {
            for (State state : spt.getAllStates()) {
                Vertex targetVertex = state.getVertex();
                if (originVertices.contains(targetVertex)) continue;
                if (targetVertex instanceof TransitStopVertex && state.isFinal()) {
                    stopsFound.add(NearbyStop.nearbyStopForState(state, ((TransitStopVertex)targetVertex).getStop()));
                }
                if (!OTPFeature.FlexRouting.isOn() || !(targetVertex instanceof StreetVertex) || ((StreetVertex)targetVertex).areaStops == null) continue;
                for (AreaStop areaStop : ((StreetVertex)targetVertex).areaStops) {
                    if (!this.canBoardFlex(state, reverseDirection)) continue;
                    locationsMap.put((Object)areaStop, (Object)state);
                }
            }
        }
        if (OTPFeature.FlexRouting.isOn()) {
            for (Map.Entry entry : locationsMap.asMap().entrySet()) {
                AreaStop areaStop = (AreaStop)entry.getKey();
                Collection states = (Collection)entry.getValue();
                State min = Collections.min(states, Comparator.comparing(State::getWeight));
                if (min.getBackState().getVertex() instanceof TemporaryStreetLocation) {
                    min = min.getBackState();
                }
                stopsFound.add(NearbyStop.nearbyStopForState(min, areaStop));
            }
        }
        return stopsFound;
    }

    private List<NearbyStop> findNearbyStopsViaDirectTransfers(Vertex vertex) {
        double limitMeters = (double)this.durationLimit.toSeconds() * WalkPreferences.DEFAULT.speed();
        Coordinate c0 = vertex.getCoordinate();
        return this.directGraphFinder.findClosestStops(c0, limitMeters);
    }

    private SkipEdgeStrategy<State, Edge> getSkipEdgeStrategy(boolean reverseDirection, RouteRequest routingRequest) {
        DurationSkipEdgeStrategy<State, Edge> durationSkipEdgeStrategy = new DurationSkipEdgeStrategy<State, Edge>(this.durationLimit);
        if (!reverseDirection && OTPFeature.VehicleToStopHeuristics.isOn() && VehicleToStopSkipEdgeStrategy.applicableModes.contains((Object)routingRequest.journey().access().mode())) {
            VehicleToStopSkipEdgeStrategy strategy = new VehicleToStopSkipEdgeStrategy(this.transitService::getPatternsForStop, routingRequest.journey().transit().filters());
            return new ComposingSkipEdgeStrategy<State, Edge>(strategy, durationSkipEdgeStrategy);
        }
        if (OTPFeature.VehicleToStopHeuristics.isOn() && routingRequest.journey().access().mode() == StreetMode.BIKE) {
            BikeToStopSkipEdgeStrategy strategy = new BikeToStopSkipEdgeStrategy(this.transitService::getTripsForStop);
            return new ComposingSkipEdgeStrategy<State, Edge>(strategy, durationSkipEdgeStrategy);
        }
        return durationSkipEdgeStrategy;
    }

    private static List<NearbyStop> createDirectlyConnectedStops(Set<Vertex> originVertices, boolean reverseDirection, RouteRequest request, StreetRequest streetRequest) {
        ArrayList<NearbyStop> stopsFound = new ArrayList<NearbyStop>();
        StreetSearchRequest streetSearchRequest = StreetSearchRequestMapper.mapToTransferRequest(request).withArriveBy(reverseDirection).withMode(streetRequest.mode()).build();
        for (Vertex vertex : originVertices) {
            if (!(vertex instanceof TransitStopVertex)) continue;
            TransitStopVertex tsv = (TransitStopVertex)vertex;
            stopsFound.add(new NearbyStop(tsv.getStop(), 0.0, Collections.emptyList(), new State(vertex, streetSearchRequest)));
        }
        return stopsFound;
    }

    private boolean canBoardFlex(State state, boolean reverse) {
        Collection<Edge> edges = reverse ? state.getVertex().getIncoming() : state.getVertex().getOutgoing();
        return edges.stream().anyMatch(e -> e instanceof StreetEdge && ((StreetEdge)e).getPermission().allows(TraverseMode.CAR));
    }
}

