/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.issues;

import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;

public record HopSpeedSlow(float metersPerSecond, float distance, Trip trip, int seq, StopLocation fromStop, StopLocation toStop) implements DataImportIssue
{
    private static final String FMT = "Very slow speed of %.2f kph over %.1fm on route %s trip %s stop sequence %d between %s and %s.";

    @Override
    public String getMessage() {
        double kph = (double)this.metersPerSecond * 3.6;
        return String.format(FMT, kph, Float.valueOf(this.distance), this.trip.getRoute().getId(), this.trip.getId(), this.seq, this.fromStop, this.toStop);
    }

    @Override
    public int getPriority() {
        return (int)(this.metersPerSecond * -100.0f);
    }

    @Override
    public Geometry getGeometry() {
        return GeometryUtils.makeLineString(List.of(this.fromStop.getCoordinate().asJtsCoordinate(), this.toStop.getCoordinate().asJtsCoordinate()));
    }
}

