/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.issues;

import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.openstreetmap.model.OSMNode;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

public record DisconnectedOsmNode(OSMNode node, OSMWithTags way, OSMWithTags area) implements DataImportIssue
{
    private static final String FMT = "Node %s in way %s is coincident but disconnected with area %s";
    private static final String HTMLFMT = "Node<a href='%s'>'%s'</a> in way <a href='%s'>'%s'</a> is coincident but disconnected with area <a href='%s'>'%s'</a>";

    @Override
    public String getMessage() {
        return String.format(FMT, this.node.getId(), this.way.getId(), this.area.getId());
    }

    @Override
    public String getHTMLMessage() {
        return String.format(HTMLFMT, this.node.getOpenStreetMapLink(), this.node.getId(), this.way.getOpenStreetMapLink(), this.way.getId(), this.area.getOpenStreetMapLink(), this.area.getId());
    }

    @Override
    public Geometry getGeometry() {
        return GeometryUtils.getGeometryFactory().createPoint(this.node.getCoordinate());
    }
}

