/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.issue.report;

import java.awt.Color;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class IssueColors {
    private static final Map<String, Color> ASSIGNED_COLOR = new ConcurrentHashMap<String, Color>();
    private static final Color[] BG_COLORS = new Color[]{new Color(0xFFFF80), new Color(0xFFD0FF), new Color(9488639), new Color(16769120), new Color(11599680), new Color(0xFF80FF), new Color(7381247), new Color(0xFFC000), new Color(8453952), new Color(0xFFB0FF), new Color(9494783), new Color(0xFFA000), new Color(14745456), new Color(13672703), new Color(0xB0FFFF), new Color(0xFF8080), new Color(0x40FF40), new Color(10522879), new Color(9502688), new Color(16736432), new Color(7405488), new Color(0xFFFF40)};

    IssueColors() {
    }

    static String rgb(String issueType) {
        return String.format("#%06X", IssueColors.backgroundColor(issueType).getRGB() & 0xFFFFFF);
    }

    private static Color backgroundColor(String issueType) {
        return ASSIGNED_COLOR.computeIfAbsent(issueType, key -> IssueColors.nextColor());
    }

    private static Color nextColor() {
        return BG_COLORS[ASSIGNED_COLOR.size() % BG_COLORS.length];
    }
}

