/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.issue.report;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.geojson.MultiPolygon;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.graph_builder.issue.report.Bucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoJsonWriter {
    private static final Logger LOG = LoggerFactory.getLogger(GeoJsonWriter.class);
    private final DataSource target;
    private final Collection<DataImportIssue> issues;

    GeoJsonWriter(CompositeDataSource reportDirectory, Bucket bucket) {
        this.target = reportDirectory.entry(bucket.key().key() + ".geojson");
        this.issues = bucket.issues();
    }

    boolean writeFile() {
        List<DataImportIssue> filteredIssues = this.issues.stream().filter(issue -> issue.getGeometry() != null).toList();
        if (filteredIssues.isEmpty()) {
            return false;
        }
        SimpleFeatureCollection featureCollection = GeoJsonWriter.makeContourFeatures(this.issues);
        try (GeoJSONWriter geoJSONWriter = new GeoJSONWriter(this.target.asOutputStream());){
            geoJSONWriter.setMaxDecimals(6);
            geoJSONWriter.setPrettyPrinting(true);
            geoJSONWriter.writeFeatureCollection(featureCollection);
        }
        catch (IOException e) {
            LOG.error("Unable to write GeoJSON", (Throwable)e);
            return false;
        }
        return true;
    }

    private static SimpleFeatureCollection makeContourFeatures(Collection<DataImportIssue> issues) {
        SimpleFeatureType schema = GeoJsonWriter.makeDataIssueSchema();
        DefaultFeatureCollection featureCollection = new DefaultFeatureCollection(null, schema);
        SimpleFeatureBuilder fbuilder = new SimpleFeatureBuilder(schema);
        for (DataImportIssue issue : issues) {
            fbuilder.add((Object)issue.getGeometry());
            fbuilder.add((Object)issue.getMessage());
            featureCollection.add(fbuilder.buildFeature(null));
        }
        return featureCollection;
    }

    private static SimpleFeatureType makeDataIssueSchema() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("dataImportIssues");
        typeBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        typeBuilder.setDefaultGeometry("the_geom");
        typeBuilder.add("the_geom", MultiPolygon.class);
        typeBuilder.add("description", String.class);
        return typeBuilder.buildFeatureType();
    }
}

