/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.issue.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataImportIssueSummary
implements Serializable {
    private static final Logger ISSUE_LOG = LoggerFactory.getLogger((String)"DATA_IMPORT_ISSUES");
    private Map<String, Long> summary;

    public DataImportIssueSummary(List<DataImportIssue> issues) {
        this(issues.stream().map(DataImportIssue::getType).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())));
    }

    private DataImportIssueSummary(Map<String, Long> summary) {
        this.summary = Map.copyOf(summary);
    }

    public static DataImportIssueSummary combine(DataImportIssueSummary first, DataImportIssueSummary second) {
        HashMap<String, Long> combined = new HashMap<String, Long>(first.asMap());
        second.asMap().forEach((type, count) -> {
            if (combined.containsKey(type)) {
                Long countSoFar = (Long)combined.get(type);
                combined.put((String)type, count + countSoFar);
            } else {
                combined.put((String)type, (Long)count);
            }
        });
        return new DataImportIssueSummary(combined);
    }

    public static DataImportIssueSummary empty() {
        return new DataImportIssueSummary(List.of());
    }

    public void logSummary() {
        int maxLength = this.summary.keySet().stream().mapToInt(String::length).max().orElse(10);
        String FMT = "  - %-" + maxLength + "s  %,7d";
        ISSUE_LOG.info("Issue summary (number of each type):");
        this.summary.keySet().stream().sorted().forEach(issueType -> ISSUE_LOG.info(String.format(FMT, issueType, this.summary.get(issueType))));
    }

    @Nonnull
    public Map<String, Long> asMap() {
        return this.summary;
    }
}

