/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.tostring;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.framework.lang.OtpNumberFormat;
import org.opentripplanner.framework.time.DurationUtils;
import org.opentripplanner.framework.time.TimeUtils;

public class ToStringBuilder {
    private static final int RANDOM_IGNORE_VALUE = -9371207;
    private static final String FIELD_SEPARATOR = ", ";
    private static final String FIELD_VALUE_SEP = ": ";
    private static final String NULL_VALUE = "null";
    private final StringBuilder sb = new StringBuilder();
    private final OtpNumberFormat numFormat = new OtpNumberFormat();
    boolean first = true;

    private ToStringBuilder(String name) {
        this.sb.append(name).append("{");
    }

    public static ToStringBuilder of(Class<?> clazz) {
        return new ToStringBuilder(clazz.getSimpleName());
    }

    public static ToStringBuilder of() {
        return new ToStringBuilder("");
    }

    public ToStringBuilder addNum(String name, Number num) {
        return this.addIfNotNull(name, num, this.numFormat::formatNumber);
    }

    public ToStringBuilder addNum(String name, Number value, Number ignoreValue) {
        return this.addIfNotIgnored(name, value, ignoreValue, this.numFormat::formatNumber);
    }

    public ToStringBuilder addNum(String name, Number num, String unit) {
        return this.addIfNotNull(name, num, n -> this.numFormat.formatNumber((Number)n, unit));
    }

    public ToStringBuilder addCost(String name, Integer cost, Integer ignoreValue) {
        return this.addIfNotIgnored(name, cost, ignoreValue, OtpNumberFormat::formatCost);
    }

    public ToStringBuilder addCostCenti(String name, Integer cost, Integer ignoreValue) {
        return this.addIfNotIgnored(name, cost, ignoreValue, OtpNumberFormat::formatCostCenti);
    }

    public ToStringBuilder addBool(String name, Boolean value) {
        return this.addIfNotNull(name, value);
    }

    public ToStringBuilder addBoolIfTrue(String name, Boolean value) {
        if (Boolean.TRUE.equals(value)) {
            this.addLabel(name);
        }
        return this;
    }

    public ToStringBuilder addStr(String name, String value, String ignoreValue) {
        return this.addIfNotIgnored(name, value, ignoreValue, v -> "'" + v + "'");
    }

    public ToStringBuilder addStr(String name, String value) {
        return this.addStr(name, value, null);
    }

    public ToStringBuilder addEnum(String name, Enum<?> value) {
        return this.addEnum(name, value, null);
    }

    public ToStringBuilder addEnum(String name, Enum<?> value, Enum<?> ignoreValue) {
        return this.addIfNotIgnored(name, value, ignoreValue, Enum::name);
    }

    public ToStringBuilder addObj(String name, Object obj) {
        return this.addObj(name, obj, null);
    }

    public ToStringBuilder addObj(String name, Object value, @Nullable Object ignoreValue) {
        return this.addIfNotIgnored(name, value, ignoreValue, Object::toString);
    }

    public <T> ToStringBuilder addObjOp(String name, @Nullable T value, Function<T, Object> toObjectOp) {
        return this.addObjOp(name, value, null, toObjectOp);
    }

    public <T> ToStringBuilder addObjOp(String name, @Nullable T value, @Nullable T ignoreValue, Function<T, Object> toObjectOp) {
        return this.addIfNotIgnored(name, value, ignoreValue, v -> ToStringBuilder.nullSafeToString(toObjectOp.apply(v)));
    }

    public ToStringBuilder addInts(String name, int[] intArray) {
        return this.addIfNotNull(name, intArray, Arrays::toString);
    }

    public ToStringBuilder addDoubles(String name, double[] value, double ignoreValue) {
        if (value == null) {
            return this.addIt(name, NULL_VALUE);
        }
        if (Arrays.stream(value).allMatch(it -> Objects.equals(it, ignoreValue))) {
            return this;
        }
        return this.addIt(name, Arrays.toString(value));
    }

    public ToStringBuilder addCol(String name, Collection<?> c) {
        return this.addIfNotNull(name, c == null || c.isEmpty() ? null : c);
    }

    public ToStringBuilder addCol(String name, Collection<?> c, Collection<?> ignoreValue) {
        return this.addIfNotIgnored(name, c, ignoreValue, Objects::toString);
    }

    public <T> ToStringBuilder addCol(String name, Collection<T> c, Function<T, String> toStingOp) {
        return this.addIfNotNull(name, c == null || c.isEmpty() ? null : c.stream().map(toStingOp).toList());
    }

    public ToStringBuilder addCollection(String name, Collection<?> c, int maxLimit) {
        if (c == null) {
            return this;
        }
        if (c.size() > maxLimit + 1) {
            String value = c.stream().limit(maxLimit).map(Object::toString).collect(Collectors.joining(FIELD_SEPARATOR));
            return this.addIt(name + "(" + maxLimit + "/" + c.size() + ")", "[" + value + ", ..]");
        }
        return this.addIfNotNull(name, c);
    }

    public ToStringBuilder addColSize(String name, Collection<?> c) {
        return this.addIfNotNull(name, c, x -> String.format("%d items", x.size()));
    }

    public ToStringBuilder addIntArraySize(String name, int[] array, int notSet) {
        if (array == null) {
            return this;
        }
        return this.addIt(name, Arrays.stream(array).filter(t -> t != notSet).count() + "/" + array.length);
    }

    public ToStringBuilder addBitSetSize(String name, BitSet bitSet) {
        if (bitSet == null) {
            return this;
        }
        return this.addIt(name, bitSet.cardinality() + "/" + bitSet.length());
    }

    public ToStringBuilder addCoordinate(String name, Number num) {
        return this.addIfNotNull(name, num, this.numFormat::formatCoordinate);
    }

    public ToStringBuilder addDateTime(String name, Instant time) {
        return this.addIfNotNull(name, time, Instant::toString);
    }

    public ToStringBuilder addTime(String name, ZonedDateTime time) {
        return this.addIfNotNull(name, time, DateTimeFormatter.ISO_LOCAL_TIME::format);
    }

    public ToStringBuilder addServiceTime(String name, int timeSecondsPastMidnight, int ignoreValue) {
        return this.addIfNotIgnored(name, timeSecondsPastMidnight, ignoreValue, TimeUtils::timeToStrCompact);
    }

    public ToStringBuilder addServiceTime(String name, int timeSecondsPastMidnight) {
        return this.addIfNotIgnored(name, timeSecondsPastMidnight, -9371207, TimeUtils::timeToStrCompact);
    }

    public ToStringBuilder addServiceTimeSchedule(String name, int[] value) {
        return this.addIfNotNull(name, value, a -> Arrays.stream(a).mapToObj(TimeUtils::timeToStrCompact).collect(Collectors.joining(" ", "[", "]")));
    }

    public ToStringBuilder addDate(String name, LocalDate time) {
        return this.addIfNotNull(name, time, DateTimeFormatter.ISO_LOCAL_DATE::format);
    }

    public ToStringBuilder addDurationSec(String name, Integer durationSeconds) {
        return this.addDurationSec(name, durationSeconds, null);
    }

    public ToStringBuilder addDurationSec(String name, Integer durationSeconds, Integer ignoreValue) {
        return this.addIfNotIgnored(name, durationSeconds, ignoreValue, DurationUtils::durationToStr);
    }

    public ToStringBuilder addDuration(String name, Duration duration) {
        return this.addDuration(name, duration, null);
    }

    public ToStringBuilder addDuration(String name, Duration duration, Duration ignoreValue) {
        return this.addIfNotIgnored(name, duration, ignoreValue, d -> DurationUtils.durationToStr((int)d.toSeconds()));
    }

    public String toString() {
        return this.sb.append("}").toString();
    }

    private <T> ToStringBuilder addIfNotNull(String name, T value) {
        return this.addIfNotIgnored(name, value, null, Object::toString);
    }

    private <T> ToStringBuilder addIfNotNull(String name, T value, Function<T, String> vToString) {
        return this.addIfNotIgnored(name, value, null, vToString);
    }

    private <T> ToStringBuilder addIfNotIgnored(String name, T value, T ignoreValue, Function<T, String> mapToString) {
        if (Objects.equals(ignoreValue, value)) {
            return this;
        }
        if (value == null) {
            return this.addIt(name, NULL_VALUE);
        }
        return this.addIt(name, mapToString.apply(value));
    }

    private ToStringBuilder addIt(String name, @Nonnull String value) {
        this.addLabel(name);
        this.addValue(value);
        return this;
    }

    private void addLabel(String name) {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(FIELD_SEPARATOR);
        }
        this.sb.append(name);
    }

    private void addValue(@Nonnull String value) {
        this.sb.append(FIELD_VALUE_SEP);
        this.sb.append(value);
    }

    public static String nullSafeToString(@Nullable Object object) {
        if (object == null) {
            return NULL_VALUE;
        }
        return object.toString();
    }
}

