/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.time;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.framework.time.TimeUtils;

class RelativeTime {
    private final int days;
    private final LocalTime time;

    private RelativeTime(int days, LocalTime time) {
        this.days = days;
        this.time = time;
    }

    private RelativeTime(int days, int hours, int minutes, int seconds) {
        this(days, LocalTime.of(hours, minutes, seconds));
    }

    public ZonedDateTime toZonedDateTime(LocalDate date, ZoneId zoneId) {
        return ServiceDateUtils.asStartOfService(date, zoneId).plusDays(this.days).plusSeconds(this.time.toSecondOfDay());
    }

    static RelativeTime ofSeconds(int secondsPastMidnight) {
        boolean negative = secondsPastMidnight < 0;
        int days = secondsPastMidnight / TimeUtils.ONE_DAY_SECONDS;
        int secondsOfDay = secondsPastMidnight % TimeUtils.ONE_DAY_SECONDS;
        if (negative) {
            return new RelativeTime(days - 1, LocalTime.MIDNIGHT.plusSeconds(secondsOfDay));
        }
        return new RelativeTime(days, LocalTime.ofSecondOfDay(secondsOfDay));
    }

    static RelativeTime from(ZonedDateTime time) {
        return new RelativeTime(0, time.getHour(), time.getMinute(), time.getSecond());
    }

    String toLongStr() {
        return this.appendDays(this.timeStrLong());
    }

    String toCompactStr() {
        return this.appendDays(this.timeStrCompact());
    }

    private String timeStrCompact() {
        return this.time.getSecond() == 0 ? String.format("%d:%02d", this.time.getHour(), this.time.getMinute()) : String.format("%d:%02d:%02d", this.time.getHour(), this.time.getMinute(), this.time.getSecond());
    }

    private String timeStrLong() {
        return String.format("%02d:%02d:%02d", this.time.getHour(), this.time.getMinute(), this.time.getSecond());
    }

    private String appendDays(String body) {
        return this.days == 0 ? body : body + (this.days < 0 ? "" : "+") + this.days + "d";
    }
}

