/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.time;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class DurationUtils {
    private DurationUtils() {
    }

    public static String durationToStr(int timeSeconds) {
        StringBuilder buf = new StringBuilder();
        if (timeSeconds < 0) {
            buf.append("-");
        }
        int time = Math.abs(timeSeconds);
        int sec = time % 60;
        int min = (time /= 60) % 60;
        int hour = (time /= 60) % 24;
        int day = time / 24;
        if (day != 0) {
            buf.append(day).append('d');
        }
        if (hour != 0) {
            buf.append(hour).append('h');
        }
        if (min != 0) {
            buf.append(min).append('m');
        }
        if (sec != 0) {
            buf.append(sec).append('s');
        }
        return buf.length() == 0 ? "0s" : buf.toString();
    }

    public static String durationToStr(Duration duration) {
        return duration == null ? "" : DurationUtils.durationToStr((int)duration.toSeconds());
    }

    public static String durationToStr(int timeSeconds, int notSetValue) {
        return timeSeconds == notSetValue ? "" : DurationUtils.durationToStr(timeSeconds);
    }

    public static int durationInSeconds(String duration) {
        Duration d = DurationUtils.duration(duration);
        return (int)d.toSeconds();
    }

    public static Duration duration(String duration, ChronoUnit unit) {
        if (duration.matches("-?\\d+")) {
            return Duration.of(Integer.parseInt(duration), unit);
        }
        return DurationUtils.duration(duration);
    }

    public static Duration duration(String duration) {
        Object d = duration.toUpperCase();
        if (!((String)d).startsWith("P") && !((String)d).startsWith("-P")) {
            int pos = ((String)d).indexOf(68) + 1;
            if (pos > 0) {
                String days = ((String)d).substring(0, pos);
                d = pos == ((String)d).length() ? "P" + days : "P" + days + "T" + ((String)d).substring(pos);
            } else {
                d = "PT" + (String)d;
            }
        }
        try {
            return Duration.parse((CharSequence)d);
        }
        catch (DateTimeParseException e) {
            throw new DateTimeParseException(e.getMessage() + ": '" + duration + "'", duration, e.getErrorIndex());
        }
    }

    public static List<Duration> durations(String durations) {
        if (durations == null || durations.isBlank()) {
            return List.of();
        }
        return Arrays.stream(durations.split("[,;\\s]+")).map(DurationUtils::duration).collect(Collectors.toList());
    }

    public static String msToSecondsStr(long timeMs) {
        if (timeMs == 0L) {
            return "0 seconds";
        }
        if (timeMs == 1000L) {
            return "1 second";
        }
        if (timeMs < 100L) {
            return DurationUtils.msToSecondsStr("%.3f", timeMs);
        }
        if (timeMs < 995L) {
            return DurationUtils.msToSecondsStr("%.2f", timeMs);
        }
        if (timeMs < 9950L) {
            return DurationUtils.msToSecondsStr("%.1f", timeMs);
        }
        return DurationUtils.msToSecondsStr("%.0f", timeMs);
    }

    private static String msToSecondsStr(String formatSeconds, double timeMs) {
        return String.format(Locale.ROOT, formatSeconds, timeMs / 1000.0) + " seconds";
    }
}

