/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.time;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    private static final int SANITY_CHECK_CUTOFF_YEAR = 1000;
    private static final List<DateTimeFormatter> DF_LIST = List.of(DateTimeFormatter.ofPattern("yyyy.MM.dd.HH.mm.ss"), DateTimeFormatter.ofPattern("yyyy.MM.dd.HH.mm"), DateTimeFormatter.ofPattern("yyyy.MM.dd.HH.mm.ss.SS"), DateTimeFormatter.ofPattern("M.d.yy h.mm a"), DateTimeFormatter.ofPattern("M.d.yyyy h.mm a"), DateTimeFormatter.ofPattern("M.d.yyyy h.mma"), DateTimeFormatter.ofPattern("M.d.yyyy h.mm"), DateTimeFormatter.ofPattern("M.d.yyyy k.mm"), DateTimeFormatter.ofPattern("M.d.yyyy"), DateTimeFormatter.ofPattern("yyyy.M.d"), DateTimeFormatter.ofPattern("h.mm a"));
    private static final List<DateTimeFormatter> SMALL_DF_LIST = List.of(DateTimeFormatter.ofPattern("M.d.yy"), DateTimeFormatter.ofPattern("yy.M.d"), DateTimeFormatter.ofPattern("h.mm a"));

    public static ZonedDateTime toZonedDateTime(String date, String time, ZoneId tz) {
        LocalTime localTime;
        LOG.debug("Parsing date {} and time {}", (Object)date, (Object)time);
        LOG.debug("using timezone {}", (Object)tz);
        ZonedDateTime retVal = ZonedDateTime.ofInstant(Instant.now(), tz);
        if (date != null) {
            LocalTime localTime2;
            LocalDate localDate = DateUtils.parseDate(date);
            if (localDate == null) {
                return null;
            }
            boolean timed = false;
            if (time != null && (localTime2 = DateUtils.parseTime(time)) != null) {
                retVal = LocalDateTime.of(localDate, localTime2).atZone(tz);
                timed = true;
            }
            if (!timed) {
                retVal = LocalDateTime.of(localDate, retVal.toLocalTime()).atZone(tz);
            }
        } else if (time != null && (localTime = DateUtils.parseTime(time)) != null) {
            retVal = LocalDateTime.of(retVal.toLocalDate(), localTime).atZone(tz);
        }
        LOG.debug("resulting date is {}", (Object)retVal);
        return retVal;
    }

    public static LocalDate parseDate(@Nonnull String input) {
        LocalDate retVal = null;
        try {
            Object newString = input.trim().replace('_', '.').replace('-', '.').replace(':', '.').replace('/', '.');
            List<DateTimeFormatter> dateTimeFormatterList = DF_LIST;
            if (((String)newString).length() <= 8) {
                if (((String)newString).matches("\\d\\d\\d\\d\\d\\d\\d\\d")) {
                    newString = ((String)newString).substring(0, 4) + "." + ((String)newString).substring(4, 6) + "." + ((String)newString).substring(6, 8);
                } else if (!((String)newString).matches(".*20\\d\\d.*")) {
                    dateTimeFormatterList = SMALL_DF_LIST;
                }
            }
            for (DateTimeFormatter dateTimeFormatter : dateTimeFormatterList) {
                try {
                    int year;
                    retVal = LocalDate.parse((CharSequence)newString, dateTimeFormatter);
                    if (retVal == null || (year = retVal.getYear()) < 1000) continue;
                    break;
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse " + input);
        }
        return retVal;
    }

    public static int getIntegerFromString(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String secToHHMM(int seconds) {
        int min;
        String sign = "";
        if (seconds >= 0) {
            min = seconds / 60;
            sign = "";
        } else {
            min = -seconds / 60;
            sign = "-";
        }
        int mm = min % 60;
        int hh = min / 60;
        return String.format("%s%d:%02d", sign, hh, mm);
    }

    public static String trim(String str) {
        String retVal = str;
        try {
            retVal = str.trim();
            retVal = retVal.replaceAll("%20;", "");
            retVal = retVal.replaceAll("%20", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static long absoluteTimeout(Duration timeout) {
        if (timeout == null) {
            return Long.MAX_VALUE;
        }
        return System.currentTimeMillis() + timeout.toMillis();
    }

    private static LocalTime parseTime(String time) {
        boolean amPm = false;
        int addHours = 0;
        int hour = 0;
        int min = 0;
        int sec = 0;
        try {
            String[] hms = time.toUpperCase().split(":");
            if (hms.length < 2) {
                return LocalTime.ofSecondOfDay(DateUtils.getIntegerFromString(time));
            }
            if (hms[1].endsWith("PM") || hms[1].endsWith("AM")) {
                int suffex;
                amPm = true;
                if (hms[1].contains("PM")) {
                    addHours = 12;
                }
                if ((suffex = hms[1].lastIndexOf(32)) < 1 && (suffex = hms[1].lastIndexOf("AM")) < 1) {
                    suffex = hms[1].lastIndexOf("PM");
                }
                hms[1] = hms[1].substring(0, suffex);
            }
            int h = Integer.parseInt(DateUtils.trim(hms[0]));
            if (amPm && h == 12) {
                h = 0;
            }
            hour = h + addHours;
            min = Integer.parseInt(DateUtils.trim(hms[1]));
            if (hms.length > 2) {
                sec = Integer.parseInt(DateUtils.trim(hms[2]));
            }
            return LocalTime.of(hour, min, sec);
        }
        catch (Exception ignore) {
            LOG.info("Time '{}' didn't parse", (Object)time);
            return null;
        }
    }
}

