/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.framework.lang.ObjectUtils;
import org.opentripplanner.framework.lang.StringUtils;
import org.opentripplanner.framework.text.TableBuilder;
import org.opentripplanner.framework.text.TableRowFormatter;

public class Table {
    public static final String EMPTY_STRING = "";
    private static final char SPACE = ' ';
    private final List<Align> aligns;
    private final List<String> headers;
    private final List<Integer> widths;
    private final List<List<String>> rows = new ArrayList<List<String>>();

    Table(TableBuilder builder) {
        this.headers = List.copyOf(builder.headers());
        this.aligns = List.copyOf(builder.aligns());
        this.widths = builder.calculateWidths();
        this.rows.addAll(builder.rows());
        int nColumns = this.nColumns();
        this.assertSize(this.aligns, nColumns);
        this.assertSize(this.widths, nColumns);
        this.rows.forEach(row -> this.assertSize((List<?>)row, nColumns));
    }

    public static TableBuilder of() {
        return new TableBuilder();
    }

    public List<String> toMarkdownRows() {
        ArrayList<String> list = new ArrayList<String>();
        TableRowFormatter f = TableRowFormatter.markdownFormatter(this.aligns, this.widths);
        list.add(f.format(this.headers));
        list.add(f.markdownHeaderLine());
        for (List<String> row : this.rows) {
            list.add(f.format(row));
        }
        return list;
    }

    public String toMarkdownTable() {
        return String.join((CharSequence)"\n", this.toMarkdownRows()) + "\n";
    }

    public List<String> toTextRows() {
        ArrayList<String> list = new ArrayList<String>();
        TableRowFormatter f = TableRowFormatter.logFormatter(this.aligns, this.widths);
        list.add(f.format(this.headers));
        for (List<String> row : this.rows) {
            list.add(f.format(row));
        }
        return list;
    }

    public String headerRow() {
        return TableRowFormatter.logFormatter(this.aligns, this.widths).format(this.headers);
    }

    public String rowAsText(Object ... row) {
        List<String> list = Table.normalizeRow(Arrays.asList(row), this.nColumns());
        return TableRowFormatter.logFormatter(this.aligns, this.widths).format(list);
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.toTextRows()) + "\n";
    }

    private void assertSize(List<?> list, int size) {
        if (list.size() != size) {
            throw new IllegalStateException("The number of columns is for headers, aligns and width must be the same.");
        }
    }

    private int nColumns() {
        return this.headers.size();
    }

    static List<String> normalizeRow(Collection<?> row, int nColumns) {
        ArrayList<String> list = new ArrayList<String>(row.stream().map(ObjectUtils::toString).map(it -> it.replace('\n', ' ')).map(String::trim).toList());
        while (list.size() < nColumns) {
            list.add(EMPTY_STRING);
        }
        return list;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Align {
        Left{

            @Override
            String pad(String value, int width) {
                return StringUtils.padRight(value, ' ', width);
            }
        }
        ,
        Center{

            @Override
            String pad(String value, int width) {
                return StringUtils.padBoth(value, ' ', width);
            }
        }
        ,
        Right{

            @Override
            String pad(String value, int width) {
                return StringUtils.padLeft(value, ' ', width);
            }
        };


        abstract String pad(String var1, int var2);
    }
}

