/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.logging;

import org.opentripplanner.framework.logging.AbstractFilterLogger;
import org.slf4j.Logger;

public class ThrottleLogger
extends AbstractFilterLogger {
    private static final int STALL_PERIOD_MILLISECONDS = 1000;
    private long timeout = Long.MIN_VALUE;

    private ThrottleLogger(Logger delegate) {
        super(delegate);
        delegate.info("Logger {} is throttled, only one messages is logged for every {} second interval.", (Object)delegate.getName(), (Object)1);
    }

    public static Logger throttle(Logger log) {
        return new ThrottleLogger(log);
    }

    @Override
    boolean mute() {
        return this.throttle();
    }

    private boolean throttle() {
        long time = System.currentTimeMillis();
        if (time < this.timeout) {
            return true;
        }
        this.timeout = time + 1000L;
        return false;
    }
}

