/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.lang;

import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.Nullable;

public class DoubleUtils {
    public static double roundToZeroDecimals(double value) {
        return DoubleUtils.roundToNDecimals(value, 0);
    }

    public static double roundTo1Decimal(double value) {
        return DoubleUtils.roundToNDecimals(value, 1);
    }

    public static Double roundTo2Decimals(@Nullable Double value) {
        return value == null ? null : Double.valueOf(DoubleUtils.roundTo2Decimals((double)value));
    }

    public static double roundTo2Decimals(double value) {
        return DoubleUtils.roundToNDecimals(value, 2);
    }

    public static double roundTo3Decimals(double value) {
        return DoubleUtils.roundToNDecimals(value, 3);
    }

    public static double roundTo4Decimals(double value) {
        return DoubleUtils.roundToNDecimals(value, 4);
    }

    public static Double roundTo7Decimals(@Nullable Double value) {
        return value == null ? null : Double.valueOf(DoubleUtils.roundTo7Decimals((double)value));
    }

    public static double roundTo7Decimals(double value) {
        return DoubleUtils.roundToNDecimals(value, 7);
    }

    public static boolean doubleEquals(double a, double b) {
        return Double.compare(a, b) == 0;
    }

    public static double assertInRange(double value, double min, double max, String field) {
        if (value < min || value > max) {
            throw new IllegalArgumentException("The %s is not in range[%.1f, %.1f]: %.1f".formatted(field, min, max, value));
        }
        return value;
    }

    private static double roundToNDecimals(double value, int decimals) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return value;
        }
        return BigDecimal.valueOf(value).setScale(decimals, RoundingMode.HALF_UP).doubleValue();
    }
}

